/*
 * Decompiled with CFR 0.152.
 */
package org.notritik.rxmenu.models;

import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.notritik.rxmenu.RxMenu;
import org.notritik.rxmenu.models.Menu;

public class MenuAction {
    private final String type;
    private final String data;

    private MenuAction(String type, String data) {
        this.type = type;
        this.data = data;
    }

    public String getType() {
        return this.type;
    }

    public String getData() {
        return this.data;
    }

    public void execute(Player player) {
        if (player == null || !player.isOnline()) {
            return;
        }
        try {
            String processedData = ChatColor.translateAlternateColorCodes((char)'&', (String)this.data).replace("%player%", player.getName());
            switch (this.type) {
                case "close": {
                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)RxMenu.getInstance(), () -> ((Player)player).closeInventory());
                    break;
                }
                case "message": {
                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)RxMenu.getInstance(), () -> player.sendMessage(processedData));
                    break;
                }
                case "broadcast": {
                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)RxMenu.getInstance(), () -> Bukkit.broadcastMessage((String)processedData));
                    break;
                }
                case "open": {
                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)RxMenu.getInstance(), () -> {
                        Menu menu = RxMenu.getInstance().getMenuConfig().getMenu(processedData);
                        if (menu != null) {
                            menu.open(player);
                        }
                    });
                    break;
                }
                case "command": {
                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)RxMenu.getInstance(), () -> {
                        String command = processedData;
                        if (command.startsWith("/")) {
                            command = command.substring(1);
                        }
                        player.performCommand(command);
                    });
                    break;
                }
                case "console": {
                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)RxMenu.getInstance(), () -> {
                        String command = processedData;
                        if (command.startsWith("/")) {
                            command = command.substring(1);
                        }
                        Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command);
                    });
                }
            }
        }
        catch (Exception e) {
            Bukkit.getLogger().warning("Error executing " + this.type + " action: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public static MenuAction close() {
        return new MenuAction("close", "");
    }

    public static MenuAction command(String command) {
        return new MenuAction("command", command);
    }

    public static MenuAction message(String message) {
        return new MenuAction("message", message);
    }

    public static MenuAction consoleCommand(String command) {
        return new MenuAction("console", command);
    }

    public static MenuAction broadcast(String message) {
        return new MenuAction("broadcast", message);
    }

    public static MenuAction open(String menuName) {
        return new MenuAction("open", menuName);
    }
}

