/*
 * Decompiled with CFR 0.152.
 */
package org.notritik.rxmenu.models;

import com.destroystokyo.paper.profile.PlayerProfile;
import com.destroystokyo.paper.profile.ProfileProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.notritik.rxmenu.models.MenuAction;

public class MenuItem {
    private Material material;
    private String name;
    private List<String> lore;
    private List<MenuAction> actions;
    private String headTexture;

    public MenuItem(Material material, String name) {
        this.material = material;
        this.name = ChatColor.translateAlternateColorCodes((char)'&', (String)name);
        this.lore = new ArrayList<String>();
        this.actions = new ArrayList<MenuAction>();
        this.headTexture = null;
    }

    public MenuItem(ItemStack item) {
        this.material = item.getType();
        this.actions = new ArrayList<MenuAction>();
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            this.name = meta.hasDisplayName() ? meta.getDisplayName() : this.material.name();
            this.lore = meta.hasLore() ? new ArrayList(meta.getLore()) : new ArrayList();
        } else {
            this.name = this.material.name();
            this.lore = new ArrayList<String>();
        }
        this.headTexture = null;
    }

    public Material getMaterial() {
        return this.material;
    }

    public void setMaterial(Material material) {
        this.material = material;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = ChatColor.translateAlternateColorCodes((char)'&', (String)name);
    }

    public List<String> getLore() {
        return this.lore;
    }

    public void setLore(List<String> lore) {
        this.lore = lore.stream().map(line -> ChatColor.translateAlternateColorCodes((char)'&', (String)line)).collect(Collectors.toList());
    }

    public List<MenuAction> getActions() {
        return this.actions;
    }

    public void setActions(List<MenuAction> actions) {
        this.actions = actions != null ? actions : new ArrayList();
    }

    public void addAction(MenuAction action) {
        if (action != null) {
            if (this.actions == null) {
                this.actions = new ArrayList<MenuAction>();
            }
            this.actions.add(action);
        }
    }

    public void removeAction(int index) {
        if (index >= 0 && index < this.actions.size()) {
            this.actions.remove(index);
        }
    }

    public void clearActions() {
        if (this.actions != null) {
            this.actions.clear();
        }
    }

    public String getHeadTexture() {
        return this.headTexture;
    }

    public void setHeadTexture(String texture) {
        this.headTexture = texture;
    }

    public ItemStack toItemStack() {
        ItemStack item = new ItemStack(this.material);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)this.name));
            if (!this.lore.isEmpty()) {
                meta.setLore(this.lore.stream().map(line -> ChatColor.translateAlternateColorCodes((char)'&', (String)line)).collect(Collectors.toList()));
            }
            if (this.material == Material.PLAYER_HEAD && this.headTexture != null && meta instanceof SkullMeta) {
                SkullMeta skullMeta = (SkullMeta)meta;
                try {
                    PlayerProfile profile = Bukkit.getServer().createProfile(UUID.randomUUID());
                    profile.setProperty(new ProfileProperty("textures", this.headTexture, null));
                    skullMeta.setPlayerProfile(profile);
                }
                catch (Exception e) {
                    System.out.println("Failed to apply head texture: " + e.getMessage());
                    e.printStackTrace();
                }
            }
            item.setItemMeta(meta);
        }
        return item;
    }
}

