/*
 * Decompiled with CFR 0.152.
 */
package org.notritik.rxmenu.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.ChatColor;
import org.bukkit.Sound;
import org.notritik.rxmenu.RxMenu;

public class Settings {
    private static String prefix;
    private static String defaultMenu;
    private static String noPermissionMessage;
    private static String menuCreatedMessage;
    private static String menuDeletedMessage;
    private static String menuNotFoundMessage;
    private static String menuAlreadyExistsMessage;
    private static String menuRenamedMessage;
    private static String menuReloadedMessage;
    private static String menuSavedMessage;
    private static String itemAddedMessage;
    private static String itemRemovedMessage;
    private static String itemNameChangedMessage;
    private static int defaultSize;
    private static boolean autoSave;
    private static boolean allowColorInTitles;
    private static boolean closeOnClickOutside;
    private static boolean soundsEnabled;
    private static Sound openSound;
    private static float openVolume;
    private static float openPitch;
    private static Sound closeSound;
    private static float closeVolume;
    private static float closePitch;
    private static Sound clickSound;
    private static float clickVolume;
    private static float clickPitch;
    private static int autoSaveInterval;
    private static int maxCachedMenus;
    private static final Pattern HEX_PATTERN;

    public static void load(RxMenu plugin) {
        prefix = ChatColor.translateAlternateColorCodes((char)'&', (String)plugin.getConfig().getString("settings.prefix", "&8[&bRxMenu&8]&r"));
        defaultMenu = plugin.getConfig().getString("settings.default-menu", "main");
        noPermissionMessage = plugin.getConfig().getString("messages.no-permission", "&cYou don't have permission to use this command!");
        menuCreatedMessage = plugin.getConfig().getString("messages.menu-created", "&aMenu created successfully!");
        menuDeletedMessage = plugin.getConfig().getString("messages.menu-deleted", "&cMenu deleted successfully!");
        menuNotFoundMessage = plugin.getConfig().getString("messages.menu-not-found", "&cMenu not found!");
        menuAlreadyExistsMessage = plugin.getConfig().getString("messages.menu-already-exists", "&cA menu with that name already exists!");
        menuRenamedMessage = plugin.getConfig().getString("messages.menu-renamed", "&aMenu renamed successfully!");
        menuReloadedMessage = plugin.getConfig().getString("messages.menu-reloaded", "&aMenu reloaded successfully!");
        menuSavedMessage = plugin.getConfig().getString("messages.menu-saved", "&aMenu saved successfully!");
        itemAddedMessage = plugin.getConfig().getString("messages.item-added", "&aItem added successfully!");
        itemRemovedMessage = plugin.getConfig().getString("messages.item-removed", "&cItem removed successfully!");
        itemNameChangedMessage = plugin.getConfig().getString("messages.item-name-changed", "&aItem name changed successfully!");
        defaultSize = plugin.getConfig().getInt("menu-settings.default-size", 27);
        autoSave = plugin.getConfig().getBoolean("menu-settings.auto-save", true);
        allowColorInTitles = plugin.getConfig().getBoolean("menu-settings.allow-color-in-titles", true);
        closeOnClickOutside = plugin.getConfig().getBoolean("menu-settings.close-on-click-outside", true);
        soundsEnabled = plugin.getConfig().getBoolean("sounds.enabled", true);
        try {
            openSound = Sound.valueOf((String)plugin.getConfig().getString("sounds.open.sound", "BLOCK_CHEST_OPEN"));
            closeSound = Sound.valueOf((String)plugin.getConfig().getString("sounds.close.sound", "BLOCK_CHEST_CLOSE"));
            clickSound = Sound.valueOf((String)plugin.getConfig().getString("sounds.click.sound", "UI_BUTTON_CLICK"));
        }
        catch (IllegalArgumentException e) {
            plugin.getLogger().warning("Invalid sound in config.yml! Using default sounds.");
            openSound = Sound.BLOCK_CHEST_OPEN;
            closeSound = Sound.BLOCK_CHEST_CLOSE;
            clickSound = Sound.UI_BUTTON_CLICK;
        }
        openVolume = (float)plugin.getConfig().getDouble("sounds.open.volume", 1.0);
        openPitch = (float)plugin.getConfig().getDouble("sounds.open.pitch", 1.0);
        closeVolume = (float)plugin.getConfig().getDouble("sounds.close.volume", 1.0);
        closePitch = (float)plugin.getConfig().getDouble("sounds.close.pitch", 1.0);
        clickVolume = (float)plugin.getConfig().getDouble("sounds.click.volume", 1.0);
        clickPitch = (float)plugin.getConfig().getDouble("sounds.click.pitch", 1.0);
        autoSaveInterval = plugin.getConfig().getInt("performance.auto-save-interval", 300);
        maxCachedMenus = plugin.getConfig().getInt("performance.max-cached-menus", 50);
    }

    public static String getPrefix() {
        return prefix;
    }

    public static String getDefaultMenu() {
        return defaultMenu;
    }

    public static String getNoPermissionMessage() {
        return Settings.formatMessage(noPermissionMessage);
    }

    public static String getMenuCreatedMessage() {
        return Settings.formatMessage(menuCreatedMessage);
    }

    public static String getMenuDeletedMessage() {
        return Settings.formatMessage(menuDeletedMessage);
    }

    public static String getMenuNotFoundMessage() {
        return Settings.formatMessage(menuNotFoundMessage);
    }

    public static String getMenuAlreadyExistsMessage() {
        return Settings.formatMessage(menuAlreadyExistsMessage);
    }

    public static String getMenuRenamedMessage() {
        return Settings.formatMessage(menuRenamedMessage);
    }

    public static String getMenuReloadedMessage() {
        return Settings.formatMessage(menuReloadedMessage);
    }

    public static String getItemAddedMessage() {
        return Settings.formatMessage(itemAddedMessage);
    }

    public static String getItemRemovedMessage() {
        return Settings.formatMessage(itemRemovedMessage);
    }

    public static String getItemNameChangedMessage() {
        return Settings.formatMessage(itemNameChangedMessage);
    }

    public static int getDefaultSize() {
        return defaultSize;
    }

    public static boolean isAutoSave() {
        return autoSave;
    }

    public static boolean isAllowColorInTitles() {
        return allowColorInTitles;
    }

    public static boolean isCloseOnClickOutside() {
        return closeOnClickOutside;
    }

    public static boolean isSoundsEnabled() {
        return soundsEnabled;
    }

    public static Sound getOpenSound() {
        return openSound;
    }

    public static float getOpenVolume() {
        return openVolume;
    }

    public static float getOpenPitch() {
        return openPitch;
    }

    public static Sound getCloseSound() {
        return closeSound;
    }

    public static float getCloseVolume() {
        return closeVolume;
    }

    public static float getClosePitch() {
        return closePitch;
    }

    public static Sound getClickSound() {
        return clickSound;
    }

    public static float getClickVolume() {
        return clickVolume;
    }

    public static float getClickPitch() {
        return clickPitch;
    }

    public static int getAutoSaveInterval() {
        return autoSaveInterval;
    }

    public static int getMaxCachedMenus() {
        return maxCachedMenus;
    }

    public static String formatMessage(String message) {
        if (message == null) {
            return "";
        }
        Matcher matcher = HEX_PATTERN.matcher(message);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            String hexColor = matcher.group(1);
            matcher.appendReplacement(buffer, ChatColor.valueOf((String)("#" + hexColor)).toString());
        }
        matcher.appendTail(buffer);
        return ChatColor.translateAlternateColorCodes((char)'&', (String)buffer.toString());
    }

    public static String getMenuSavedMessage() {
        return prefix + String.valueOf(ChatColor.GREEN) + "Menu saved successfully!";
    }

    public static String getMenuExistsMessage() {
        return Settings.getPrefix() + String.valueOf(ChatColor.RED) + "A menu with that name already exists!";
    }

    static {
        HEX_PATTERN = Pattern.compile("&#([A-Fa-f0-9]{6})");
    }
}

