/*
 * Decompiled with CFR 0.152.
 */
package dev.uten2c.raincoat.network;

import dev.uten2c.raincoat.NamedKey;
import dev.uten2c.raincoat.Protocol;
import dev.uten2c.raincoat.States;
import dev.uten2c.raincoat.debug.DebugShape;
import dev.uten2c.raincoat.debug.DebugShapes;
import dev.uten2c.raincoat.option.OptionManager;
import dev.uten2c.raincoat.util.PacketId;
import dev.uten2c.raincoat.util.StackUtils;
import java.net.URI;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.UInt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.SupervisorKt;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_407;
import net.minecraft.class_437;
import net.minecraft.class_634;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\bA\u0010\u0019J1\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\u00022\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001f\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u000f\u0010\u0018\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001f\u0010\u001a\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u0015J\u000f\u0010\u001b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u001b\u0010\u0019J\u001f\u0010\u001c\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u001c\u0010\u0015J\u0017\u0010\u001d\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u001d\u0010\u0017J\u0017\u0010\u001e\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u001e\u0010\u0017J\u0017\u0010\u001f\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u001f\u0010\u0017J\r\u0010 \u001a\u00020\n\u00a2\u0006\u0004\b \u0010\u0019J\u001f\u0010#\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\"\u001a\u00020!H\u0002\u00a2\u0006\u0004\b#\u0010$J%\u0010'\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\r2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00120%H\u0002\u00a2\u0006\u0004\b'\u0010(J\u001f\u0010'\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b'\u0010)J\u001d\u0010-\u001a\u00020\n2\u0006\u0010+\u001a\u00020*2\u0006\u0010,\u001a\u00020*\u00a2\u0006\u0004\b-\u0010.J\u0017\u0010/\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b/\u00100J\u0017\u00103\u001a\u00020\n2\u0006\u00102\u001a\u000201H\u0007\u00a2\u0006\u0004\b3\u00104J\u0017\u00105\u001a\u00020\n2\u0006\u00102\u001a\u000201H\u0007\u00a2\u0006\u0004\b5\u00104J\r\u00106\u001a\u00020\n\u00a2\u0006\u0004\b6\u0010\u0019J\u0013\u00108\u001a\u000207*\u00020\u0012H\u0002\u00a2\u0006\u0004\b8\u00109R\u001c\u0010<\u001a\n ;*\u0004\u0018\u00010:0:8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b<\u0010=R\u0014\u0010?\u001a\u00020>8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b?\u0010@\u00a8\u0006B"}, d2={"Ldev/uten2c/raincoat/network/Networking;", "", "Lnet/minecraft/class_310;", "client", "Lnet/minecraft/class_437;", "parentScreen", "", "open", "Ljava/net/URI;", "uri", "", "confirmOpenLink", "(Lnet/minecraft/class_310;Lnet/minecraft/class_437;ZLjava/net/URI;)V", "Ldev/uten2c/raincoat/util/PacketId;", "id", "Lnet/minecraft/class_2960;", "identifier", "(Ldev/uten2c/raincoat/util/PacketId;)Lnet/minecraft/class_2960;", "Lnet/minecraft/class_2540;", "buf", "onCameraRecoil", "(Lnet/minecraft/class_310;Lnet/minecraft/class_2540;)V", "onDirectionSendRequest", "(Lnet/minecraft/class_2540;)V", "onHandshakeRequest", "()V", "onOpenUrl", "onOutdatedSignal", "onRecoilAnimation", "onShapeClear", "onShapeDiscard", "onShapeDisplay", "registerListeners", "Lnet/fabricmc/fabric/api/client/networking/v1/ClientPlayNetworking$PlayChannelHandler;", "channelHandler", "registerReceiver", "(Ldev/uten2c/raincoat/util/PacketId;Lnet/fabricmc/fabric/api/client/networking/v1/ClientPlayNetworking$PlayChannelHandler;)V", "Ljava/util/function/Consumer;", "builder", "send", "(Ldev/uten2c/raincoat/util/PacketId;Ljava/util/function/Consumer;)V", "(Ldev/uten2c/raincoat/util/PacketId;Lnet/minecraft/class_2540;)V", "", "yaw", "pitch", "sendDirectionUpdate", "(FF)V", "sendEmpty", "(Ldev/uten2c/raincoat/util/PacketId;)V", "Ldev/uten2c/raincoat/NamedKey;", "key", "sendKeyPressedPacket", "(Ldev/uten2c/raincoat/NamedKey;)V", "sendKeyReleasedPacket", "sendSettingsUpdate", "Lnet/minecraft/class_243;", "readVec3d", "(Lnet/minecraft/class_2540;)Lnet/minecraft/class_243;", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "LOGGER", "Lorg/slf4j/Logger;", "Lkotlinx/coroutines/CoroutineScope;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "raincoat-fabric"})
public final class Networking {
    @NotNull
    public static final Networking INSTANCE = new Networking();
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Raincoat Networking");
    @NotNull
    private static final CoroutineScope scope = CoroutineScopeKt.CoroutineScope((CoroutineContext)Dispatchers.getDefault().plus((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null)));

    private Networking() {
    }

    public final void registerListeners() {
        ClientPlayConnectionEvents.DISCONNECT.register(Networking::registerListeners$lambda$0);
        this.registerReceiver(Protocol.INSTANCE.getHandshakeRequest(), Networking::registerListeners$lambda$1);
        this.registerReceiver(Protocol.INSTANCE.getDirectionSendRequest(), Networking::registerListeners$lambda$2);
        this.registerReceiver(Protocol.INSTANCE.getRecoilCamera(), Networking::registerListeners$lambda$3);
        this.registerReceiver(Protocol.INSTANCE.getRecoilAnimation(), Networking::registerListeners$lambda$4);
        this.registerReceiver(Protocol.INSTANCE.getOutdated(), Networking::registerListeners$lambda$5);
        this.registerReceiver(Protocol.INSTANCE.getOpenUrl(), Networking::registerListeners$lambda$6);
        this.registerReceiver(Protocol.INSTANCE.getShapeDisplay(), Networking::registerListeners$lambda$7);
        this.registerReceiver(Protocol.INSTANCE.getShapeDiscard(), Networking::registerListeners$lambda$8);
        this.registerReceiver(Protocol.INSTANCE.getShapeClear(), Networking::registerListeners$lambda$9);
    }

    private final void onHandshakeRequest() {
        States.setHandshakeReceived(true);
        States.INSTANCE.onJoinServer();
        ModMetadata metadata = ((ModContainer)FabricLoader.getInstance().getModContainer("raincoat").get()).getMetadata();
        String version = metadata.getVersion().getFriendlyString();
        class_2540 resBuf = PacketByteBufs.create();
        resBuf.method_10814(version);
        resBuf.method_10804(6);
        LOGGER.info("Send handshake packet (version: {}, protocol: {})", (Object)version, (Object)6);
        PacketId packetId = Protocol.INSTANCE.getHandshakeResponse();
        Intrinsics.checkNotNull((Object)resBuf);
        this.send(packetId, resBuf);
        this.sendSettingsUpdate();
    }

    private final void onDirectionSendRequest(class_2540 buf) {
        if (buf.readBoolean()) {
            States.INSTANCE.setDirectionSendRequestedTime(System.currentTimeMillis());
        } else {
            States.INSTANCE.setDirectionSendRequestedTime(null);
        }
    }

    private final void onCameraRecoil(class_310 client, class_2540 buf) {
        float x = buf.readFloat();
        float y = buf.readFloat();
        class_746 player = client.field_1724;
        if (player != null) {
            player.method_36456(player.method_36454() + x);
            player.method_36457(player.method_36455() + y);
        }
    }

    private final void onRecoilAnimation(class_310 client, class_2540 buf) {
        int ticks = buf.method_10816();
        class_746 class_7462 = client.field_1724;
        if (class_7462 == null) {
            return;
        }
        class_746 player = class_7462;
        class_1799 stack = player.method_6047();
        Intrinsics.checkNotNull((Object)stack);
        if (!StackUtils.isGun(stack)) {
            return;
        }
        States.setRecoiling(true);
        BuildersKt.launch$default((CoroutineScope)scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(ticks, null){
            int label;
            final /* synthetic */ int $ticks;
            {
                this.$ticks = $ticks;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = DelayKt.delay((long)(50L * (long)this.$ticks), (Continuation)((Continuation)this));
                        if (v0 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        States.setRecoiling(false);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void onOutdatedSignal() {
        States.INSTANCE.reset();
    }

    private final void onOpenUrl(class_310 client, class_2540 buf) {
        try {
            class_437 currentScreen = client.field_1755;
            String urlString = buf.method_19772();
            boolean trusted = buf.readBoolean();
            URI uri = new URI(urlString);
            Object object = client.field_1690.method_42431().method_41753();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
            if (((Boolean)object).booleanValue()) {
                client.execute(() -> Networking.onOpenUrl$lambda$11(urlString, trusted, client, currentScreen, uri));
            } else {
                class_156.method_668().method_673(uri);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private final void onShapeDisplay(class_2540 buf) {
        class_2960 id = buf.method_10810();
        int typeId = buf.method_10816();
        DebugShape debugShape = switch (typeId) {
            case 0 -> new DebugShape.Box(this.readVec3d(buf), this.readVec3d(buf), UInt.constructor-impl((int)buf.method_10816()), null);
            case 1 -> {
                class_243 v1 = this.readVec3d(buf);
                class_243 v2 = this.readVec3d(buf);
                Quaternionf v3 = buf.method_49070();
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"readQuaternionf(...)");
                yield new DebugShape.RotateBox(v1, v2, v3, UInt.constructor-impl((int)buf.method_10816()), null);
            }
            case 2 -> {
                class_243 v4 = this.readVec3d(buf);
                class_2561 v5 = buf.method_10808();
                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"readText(...)");
                yield new DebugShape.Message(v4, v5, buf.readFloat(), buf.readBoolean());
            }
            default -> throw new IllegalStateException();
        };
        Intrinsics.checkNotNull((Object)id);
        DebugShapes.INSTANCE.addShape(id, debugShape);
    }

    private final void onShapeDiscard(class_2540 buf) {
        class_2960 class_29602 = buf.method_10810();
        Intrinsics.checkNotNullExpressionValue((Object)class_29602, (String)"readIdentifier(...)");
        DebugShapes.INSTANCE.removeShape(class_29602);
    }

    private final void onShapeClear(class_2540 buf) {
        String namespace = (String)buf.method_43827(Networking::onShapeClear$lambda$12);
        if (namespace == null) {
            DebugShapes.INSTANCE.clearShapes();
        } else {
            DebugShapes.INSTANCE.clearShapesWithNamespace(namespace);
        }
    }

    private final void confirmOpenLink(class_310 client, class_437 parentScreen, boolean open, URI uri) {
        if (open) {
            class_156.method_668().method_673(uri);
        }
        client.method_1507(parentScreen);
    }

    @JvmStatic
    public static final void sendKeyPressedPacket(@NotNull NamedKey key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        INSTANCE.send(Protocol.INSTANCE.getKeyPressed(), arg_0 -> Networking.sendKeyPressedPacket$lambda$13(key, arg_0));
    }

    @JvmStatic
    public static final void sendKeyReleasedPacket(@NotNull NamedKey key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        INSTANCE.send(Protocol.INSTANCE.getKeyReleased(), arg_0 -> Networking.sendKeyReleasedPacket$lambda$14(key, arg_0));
    }

    public final void sendDirectionUpdate(float yaw, float pitch) {
        Long l = States.INSTANCE.getDirectionSendRequestedTime();
        if (l == null) {
            return;
        }
        long requestedTime = l;
        this.send(Protocol.INSTANCE.getDirectionUpdate(), arg_0 -> Networking.sendDirectionUpdate$lambda$15(requestedTime, yaw, pitch, arg_0));
    }

    public final void sendSettingsUpdate() {
        this.send(Protocol.INSTANCE.getSettingsUpdate(), Networking::sendSettingsUpdate$lambda$16);
    }

    private final void registerReceiver(PacketId id, ClientPlayNetworking.PlayChannelHandler channelHandler) {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)this.identifier(id), (ClientPlayNetworking.PlayChannelHandler)channelHandler);
    }

    private final void send(PacketId id, class_2540 buf) {
        if (States.isOnServer()) {
            ClientPlayNetworking.send((class_2960)this.identifier(id), (class_2540)buf);
        }
    }

    private final void send(PacketId id, Consumer<class_2540> builder) {
        class_2540 buf = PacketByteBufs.create();
        builder.accept(buf);
        Intrinsics.checkNotNull((Object)buf);
        this.send(id, buf);
    }

    private final void sendEmpty(PacketId id) {
        class_2540 class_25402 = PacketByteBufs.empty();
        Intrinsics.checkNotNullExpressionValue((Object)class_25402, (String)"empty(...)");
        this.send(id, class_25402);
    }

    private final class_2960 identifier(PacketId id) {
        return new class_2960(id.toString());
    }

    private final class_243 readVec3d(class_2540 $this$readVec3d) {
        return new class_243($this$readVec3d.readDouble(), $this$readVec3d.readDouble(), $this$readVec3d.readDouble());
    }

    private static final void registerListeners$lambda$0(class_634 class_6342, class_310 class_3102) {
        States.INSTANCE.reset();
    }

    private static final void registerListeners$lambda$1(class_310 class_3102, class_634 class_6342, class_2540 class_25402, PacketSender packetSender) {
        INSTANCE.onHandshakeRequest();
    }

    private static final void registerListeners$lambda$2(class_310 class_3102, class_634 class_6342, class_2540 buf, PacketSender packetSender) {
        Intrinsics.checkNotNull((Object)buf);
        INSTANCE.onDirectionSendRequest(buf);
    }

    private static final void registerListeners$lambda$3(class_310 client, class_634 class_6342, class_2540 buf, PacketSender packetSender) {
        Intrinsics.checkNotNull((Object)client);
        Intrinsics.checkNotNull((Object)buf);
        INSTANCE.onCameraRecoil(client, buf);
    }

    private static final void registerListeners$lambda$4(class_310 client, class_634 class_6342, class_2540 buf, PacketSender packetSender) {
        Intrinsics.checkNotNull((Object)client);
        Intrinsics.checkNotNull((Object)buf);
        INSTANCE.onRecoilAnimation(client, buf);
    }

    private static final void registerListeners$lambda$5(class_310 class_3102, class_634 class_6342, class_2540 class_25402, PacketSender packetSender) {
        INSTANCE.onOutdatedSignal();
    }

    private static final void registerListeners$lambda$6(class_310 client, class_634 class_6342, class_2540 buf, PacketSender packetSender) {
        Intrinsics.checkNotNull((Object)client);
        Intrinsics.checkNotNull((Object)buf);
        INSTANCE.onOpenUrl(client, buf);
    }

    private static final void registerListeners$lambda$7(class_310 class_3102, class_634 class_6342, class_2540 buf, PacketSender packetSender) {
        Intrinsics.checkNotNull((Object)buf);
        INSTANCE.onShapeDisplay(buf);
    }

    private static final void registerListeners$lambda$8(class_310 class_3102, class_634 class_6342, class_2540 buf, PacketSender packetSender) {
        Intrinsics.checkNotNull((Object)buf);
        INSTANCE.onShapeDiscard(buf);
    }

    private static final void registerListeners$lambda$9(class_310 class_3102, class_634 class_6342, class_2540 buf, PacketSender packetSender) {
        Intrinsics.checkNotNull((Object)buf);
        INSTANCE.onShapeClear(buf);
    }

    private static final void onOpenUrl$lambda$11$lambda$10(class_310 $client, class_437 $currentScreen, URI $uri, boolean open) {
        Intrinsics.checkNotNullParameter((Object)$client, (String)"$client");
        Intrinsics.checkNotNullParameter((Object)$uri, (String)"$uri");
        INSTANCE.confirmOpenLink($client, $currentScreen, open, $uri);
    }

    private static final void onOpenUrl$lambda$11(String $urlString, boolean $trusted, class_310 $client, class_437 $currentScreen, URI $uri) {
        Intrinsics.checkNotNullParameter((Object)$client, (String)"$client");
        Intrinsics.checkNotNullParameter((Object)$uri, (String)"$uri");
        class_407 confirmScreen = new class_407(arg_0 -> Networking.onOpenUrl$lambda$11$lambda$10($client, $currentScreen, $uri, arg_0), $urlString, $trusted);
        $client.method_1507((class_437)confirmScreen);
    }

    private static final String onShapeClear$lambda$12(class_2540 it) {
        return it.method_19772();
    }

    private static final void sendKeyPressedPacket$lambda$13(NamedKey $key, class_2540 buf) {
        Intrinsics.checkNotNullParameter((Object)$key, (String)"$key");
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        buf.method_10817((Enum)$key);
    }

    private static final void sendKeyReleasedPacket$lambda$14(NamedKey $key, class_2540 buf) {
        Intrinsics.checkNotNullParameter((Object)$key, (String)"$key");
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        buf.method_10817((Enum)$key);
    }

    private static final void sendDirectionUpdate$lambda$15(long $requestedTime, float $yaw, float $pitch, class_2540 buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        buf.method_10804((int)(System.currentTimeMillis() - $requestedTime));
        buf.writeFloat($yaw);
        buf.writeFloat($pitch);
    }

    private static final void sendSettingsUpdate$lambda$16(class_2540 buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        buf.writeBoolean(OptionManager.getOptions().isAdsHold());
    }
}

