#> tridentallweatherchanneling:image/set_image_data
#
# This function sets the image data.
#
# @input $(image_data) {string[][]} The data to set  
# @input $(width) {number} The width of the image  
# @input $(height) {number} The height of the image  
# @input $(background_color) {string} The background color of the image  
# @input $(description) {string[]} The description on the right hand side  
# @writes storage tridentallweatherchanneling:image image_data  
# @writes storage tridentallweatherchanneling:image width  
# @writes storage tridentallweatherchanneling:image height  
# @writes storage tridentallweatherchanneling:image background_color  
# @writes storage tridentallweatherchanneling:image description  
# @writes storage tridentallweatherchanneling:image pixel_character.blank  
# @writes storage tridentallweatherchanneling:image pixel_character.chat  
# @writes storage tridentallweatherchanneling:image pixel_character.lore

data remove storage tridentallweatherchanneling:image image_data
data remove storage tridentallweatherchanneling:image width
data remove storage tridentallweatherchanneling:image height
data remove storage tridentallweatherchanneling:image background_color
data remove storage tridentallweatherchanneling:image description

$data modify storage tridentallweatherchanneling:image image_data set value $(image_data)
$data modify storage tridentallweatherchanneling:image width set value $(width)
$data modify storage tridentallweatherchanneling:image height set value $(height)
$data modify storage tridentallweatherchanneling:image background_color set value "$(background_color)"
$data modify storage tridentallweatherchanneling:image description set value $(description)

data modify storage tridentallweatherchanneling:image pixel_character.blank set value "　"
data modify storage tridentallweatherchanneling:image pixel_character.pixel set value "▌▌"
data modify storage tridentallweatherchanneling:image pixel_character.line_break set value '\n'

function tridentallweatherchanneling:image/process/generate
