/*
 * Decompiled with CFR 0.152.
 */
package dev.doublekekse.map_utils.client;

import com.mojang.brigadier.CommandDispatcher;
import dev.doublekekse.map_utils.client.path.PathRenderer;
import dev.doublekekse.map_utils.command.ClientPathEditorCommand;
import dev.doublekekse.map_utils.data.MapUtilsSavedData;
import dev.doublekekse.map_utils.gizmo.Gizmos;
import dev.doublekekse.map_utils.packet.CameraFovPacket;
import dev.doublekekse.map_utils.packet.CameraOverlayPacket;
import dev.doublekekse.map_utils.packet.CameraPositionPacket;
import dev.doublekekse.map_utils.packet.CameraRotationPacket;
import dev.doublekekse.map_utils.packet.CameraSplinePacket;
import dev.doublekekse.map_utils.packet.ClickEventPacket;
import dev.doublekekse.map_utils.packet.ClientboundSyncDataPacket;
import dev.doublekekse.map_utils.packet.handler.CameraHandlers;
import dev.doublekekse.map_utils.packet.handler.ClickEventHandler;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_636;

public class MapUtilsClient
implements ClientModInitializer {
    public static MapUtilsSavedData clientSavedData;
    public static boolean pathEditorEnabled;

    public void onInitializeClient() {
        ClientPlayNetworking.registerGlobalReceiver(CameraPositionPacket.TYPE, CameraHandlers::handlePosition);
        ClientPlayNetworking.registerGlobalReceiver(CameraRotationPacket.TYPE, CameraHandlers::handleRotation);
        ClientPlayNetworking.registerGlobalReceiver(CameraSplinePacket.TYPE, CameraHandlers::handleSpline);
        ClientPlayNetworking.registerGlobalReceiver(CameraOverlayPacket.TYPE, CameraHandlers::handleOverlay);
        ClientPlayNetworking.registerGlobalReceiver(CameraFovPacket.TYPE, CameraHandlers::handleFov);
        ClientPlayNetworking.registerGlobalReceiver(ClickEventPacket.TYPE, ClickEventHandler::handle);
        ClientPlayNetworking.registerGlobalReceiver(ClientboundSyncDataPacket.TYPE, ClientboundSyncDataPacket::handle);
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> ClientPathEditorCommand.register((CommandDispatcher<FabricClientCommandSource>)dispatcher));
        WorldRenderEvents.AFTER_ENTITIES.register(ctx -> {
            class_636 gameMode = class_310.method_1551().field_1761;
            if (!pathEditorEnabled || gameMode == null || gameMode.method_2920().method_8388()) {
                return;
            }
            class_4587 poseStack = ctx.matrixStack();
            if (poseStack == null) {
                return;
            }
            poseStack.method_22903();
            class_243 cPos = ctx.camera().method_19326();
            poseStack.method_22904(-cPos.field_1352, -cPos.field_1351, -cPos.field_1350);
            PathRenderer.render(ctx);
            Gizmos.render(ctx);
            poseStack.method_22909();
        });
    }
}

