/*
 * Decompiled with CFR 0.152.
 */
package dev.doublekekse.map_utils.client.path;

import dev.doublekekse.map_utils.client.MapUtilsClient;
import dev.doublekekse.map_utils.curve.SplineControlPoint;
import dev.doublekekse.map_utils.curve.SplinePath;
import java.util.Map;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_1921;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_9974;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class PathRenderer {
    public static void render(WorldRenderContext ctx) {
        if (MapUtilsClient.clientSavedData == null) {
            return;
        }
        for (Map.Entry<String, SplinePath> entry : MapUtilsClient.clientSavedData.paths.entrySet()) {
            PathRenderer.renderPath(ctx, entry.getValue(), entry.getKey());
        }
    }

    public static void renderPath(WorldRenderContext ctx, SplinePath path, String id) {
        class_4588 lineConsumer = ctx.consumers().getBuffer((class_1921)class_1921.field_21695);
        class_4587 poseStack = ctx.matrixStack();
        class_4587.class_4665 pose = poseStack.method_23760();
        Vector3f normal = ctx.camera().method_19335().mul(-1.0f);
        PathRenderer.renderLine(path, pose, lineConsumer, normal);
        for (SplineControlPoint controlPoint : path.controlPoints()) {
            PathRenderer.renderControlPointRotation(controlPoint, poseStack, lineConsumer, normal);
        }
        int index = 0;
        for (SplineControlPoint controlPoint : path.controlPoints()) {
            PathRenderer.renderControlPointText(controlPoint, id + ": " + index++, poseStack, ctx);
        }
    }

    static void renderLine(SplinePath path, class_4587.class_4665 pose, class_4588 lineConsumer, Vector3f normal) {
        double count = 20.0 * (double)path.size();
        int i = 0;
        while ((double)i < count) {
            double currentProgress = (double)i / count;
            double nextProgress = (double)(i + 1) / count;
            class_243 currentPos = path.getPosition(currentProgress);
            class_243 nextPos = path.getPosition(nextProgress);
            lineConsumer.method_61032(pose, currentPos.method_46409()).method_39415(-1).method_60831(pose, normal.x, normal.y, normal.z);
            lineConsumer.method_61032(pose, nextPos.method_46409()).method_39415(-1).method_60831(pose, normal.x, normal.y, normal.z);
            ++i;
        }
    }

    static void renderControlPointRotation(SplineControlPoint controlPoint, class_4587 poseStack, class_4588 lineConsumer, Vector3f normal) {
        class_241 rotation = controlPoint.rotation();
        float yaw = (float)Math.toRadians(rotation.field_1343 + 90.0f);
        float pitch = (float)Math.toRadians(-rotation.field_1342);
        float dx = (float)(Math.cos(yaw) * Math.cos(pitch));
        float dy = (float)Math.sin(pitch);
        float dz = (float)(Math.sin(yaw) * Math.cos(pitch));
        class_9974.method_62298((class_4587)poseStack, (class_4588)lineConsumer, (Vector3f)controlPoint.position().method_46409(), (class_243)new class_243((double)dx, (double)dy, (double)dz), (int)-256);
    }

    static void renderControlPointText(SplineControlPoint controlPoint, String text, class_4587 poseStack, WorldRenderContext ctx) {
        poseStack.method_22903();
        poseStack.method_22904(controlPoint.position().field_1352, controlPoint.position().field_1351, controlPoint.position().field_1350);
        poseStack.method_22907((Quaternionfc)ctx.camera().method_23767().mul(-1.0f));
        poseStack.method_22905(0.01f, -0.01f, 0.01f);
        class_327 font = class_310.method_1551().field_1772;
        int width = font.method_1727(text);
        font.method_27521(text, (float)(-width) / 2.0f, -30.0f, -1, false, poseStack.method_23760().method_23761(), ctx.consumers(), class_327.class_6415.field_33995, 0, 0xF000F0);
        poseStack.method_22909();
    }
}

