/*
 * Decompiled with CFR 0.152.
 */
package dev.doublekekse.map_utils.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.doublekekse.map_utils.MapUtils;
import dev.doublekekse.map_utils.command.argument.PathArgumentType;
import dev.doublekekse.map_utils.curve.SplineControlPoint;
import dev.doublekekse.map_utils.curve.SplinePath;
import dev.doublekekse.map_utils.data.MapUtilsSavedData;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2245;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.server.MinecraftServer;

public class PathCommand {
    static List<PathData> list = new ArrayList<PathData>();

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"path").requires(source -> source.method_9259(2))).then(class_2170.method_9247((String)"apply").then(class_2170.method_9244((String)"entity", (ArgumentType)class_2186.method_9309()).then(class_2170.method_9244((String)"duration", (ArgumentType)class_2245.method_48287((int)1)).then(class_2170.method_9244((String)"path", (ArgumentType)PathArgumentType.path()).executes(ctx -> {
            class_1297 entity = class_2186.method_9313((CommandContext)ctx, (String)"entity");
            SplinePath path = PathArgumentType.getPath((CommandContext<class_2168>)ctx, "path");
            int duration = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"duration");
            if (path == null) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43471((String)"commands.map_utils.path.not_found"));
                return -1;
            }
            PathData data = new PathData();
            data.entity = entity;
            data.path = path;
            data.pathDuration = duration;
            list.add(data);
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"commands.map_utils.path.apply.success", (Object[])new Object[]{duration}), false);
            return 1;
        })))))).then(class_2170.method_9247((String)"cancel").then(class_2170.method_9244((String)"entity", (ArgumentType)class_2186.method_9309()).executes(ctx -> {
            class_1297 entity = class_2186.method_9313((CommandContext)ctx, (String)"entity");
            list.removeIf(data -> data.entity == entity);
            return 1;
        })))).then(class_2170.method_9247((String)"list").executes(ctx -> {
            class_2168 source = (class_2168)ctx.getSource();
            MapUtilsSavedData savedData = MapUtilsSavedData.getServerData(source.method_9211());
            Set<String> ids = savedData.paths.keySet();
            source.method_9226(() -> class_2561.method_43470((String)String.join((CharSequence)", ", ids)), false);
            return 1;
        }))).then(class_2170.method_9247((String)"create").then(class_2170.method_9244((String)"id", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
            class_2168 source = (class_2168)ctx.getSource();
            MinecraftServer server = source.method_9211();
            String id = StringArgumentType.getString((CommandContext)ctx, (String)"id");
            class_1297 entity = source.method_9228();
            if (entity == null) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43471((String)"commands.map_utils.no_entity"));
                return -1;
            }
            class_243 pos = entity.method_33571();
            class_241 rotation = source.method_9210();
            ArrayList<SplineControlPoint> controlPoints = new ArrayList<SplineControlPoint>();
            controlPoints.add(new SplineControlPoint(pos, new class_241(rotation.field_1342, rotation.field_1343)));
            MapUtilsSavedData savedData = MapUtilsSavedData.getServerData(server);
            if (savedData.paths.containsKey(id)) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43471((String)"commands.map_utils.path.create.already_exists"));
                return -1;
            }
            savedData.paths.put(id, new SplinePath(controlPoints));
            MapUtils.invalidateData(server);
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43471((String)"commands.map_utils.path.create.success"), false);
            return 1;
        })))).then(class_2170.method_9247((String)"delete").then(class_2170.method_9244((String)"id", (ArgumentType)PathArgumentType.path()).executes(ctx -> {
            class_2168 source = (class_2168)ctx.getSource();
            MinecraftServer server = source.method_9211();
            SplinePath path = PathArgumentType.getPath((CommandContext<class_2168>)ctx, "id");
            String pathId = PathArgumentType.getPathId((CommandContext<class_2168>)ctx, "id");
            if (path == null) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43471((String)"commands.map_utils.path.not_found"));
                return -1;
            }
            MapUtilsSavedData savedData = MapUtilsSavedData.getServerData(server);
            savedData.paths.remove(pathId);
            MapUtils.invalidateData(server);
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"commands.map_utils.path.delete.success", (Object[])new Object[]{pathId}), true);
            return 1;
        })))).then(class_2170.method_9247((String)"edit").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"path", (ArgumentType)PathArgumentType.path()).then(class_2170.method_9247((String)"add").executes(ctx -> {
            class_2168 source = (class_2168)ctx.getSource();
            class_1297 entity = source.method_9228();
            if (entity == null) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43471((String)"commands.map_utils.no_entity"));
                return -1;
            }
            class_243 pos = entity.method_33571();
            class_241 rotation = source.method_9210();
            SplinePath path = PathArgumentType.getPath((CommandContext<class_2168>)ctx, "path");
            if (path == null) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43471((String)"commands.map_utils.path.not_found"));
                return -1;
            }
            List<SplineControlPoint> controlPoints = path.controlPoints();
            controlPoints.add(new SplineControlPoint(pos, new class_241(rotation.field_1342, rotation.field_1343)));
            MapUtils.invalidateData(source.method_9211());
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43471((String)"commands.map_utils.path.edit.add.success"), false);
            return 1;
        }))).then(class_2170.method_9247((String)"insert").then(class_2170.method_9244((String)"before", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> {
            class_2168 source = (class_2168)ctx.getSource();
            class_1297 entity = source.method_9228();
            if (entity == null) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43471((String)"commands.map_utils.no_entity"));
                return -1;
            }
            class_243 pos = entity.method_33571();
            class_241 rotation = source.method_9210();
            SplinePath path = PathArgumentType.getPath((CommandContext<class_2168>)ctx, "path");
            if (path == null) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43471((String)"commands.map_utils.path.not_found"));
                return -1;
            }
            List<SplineControlPoint> controlPoints = path.controlPoints();
            int index = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"before");
            if (index < 0 || index > controlPoints.size()) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43471((String)"commands.map_utils.path.edit.out_of_bounds"));
                return -1;
            }
            controlPoints.add(index, new SplineControlPoint(pos, new class_241(rotation.field_1342, rotation.field_1343)));
            MapUtils.invalidateData(source.method_9211());
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43471((String)"commands.map_utils.path.edit.add.success"), false);
            return 1;
        })))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"index", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> {
            class_2168 source = (class_2168)ctx.getSource();
            SplinePath path = PathArgumentType.getPath((CommandContext<class_2168>)ctx, "path");
            if (path == null) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43471((String)"commands.map_utils.path.not_found"));
                return -1;
            }
            List<SplineControlPoint> controlPoints = path.controlPoints();
            int index = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"index");
            if (controlPoints.size() <= 1) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43471((String)"commands.map_utils.path.edit.remove.to_few_control_points"));
                return -1;
            }
            if (index < 0 || index >= controlPoints.size()) {
                ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43471((String)"commands.map_utils.path.edit.out_of_bounds"));
                return -1;
            }
            controlPoints.remove(index);
            MapUtils.invalidateData(source.method_9211());
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43471((String)"commands.map_utils.path.edit.remove.success"), false);
            return 1;
        }))))));
    }

    public static void registerTickListener() {
        ServerTickEvents.START_SERVER_TICK.register(server -> {
            for (int i = list.size() - 1; i >= 0; --i) {
                PathData data = list.get(i);
                float progress = (float)data.pathTicks / (float)data.pathDuration;
                if (progress > 1.0f || data.entity == null) {
                    list.remove(i);
                    continue;
                }
                ++data.pathTicks;
                class_243 pos = data.path.getPosition(progress);
                class_241 rot = data.path.getRotation(progress);
                data.entity.method_33574(pos);
                data.entity.method_60608(rot.field_1343, rot.field_1342);
            }
        });
    }

    static class PathData {
        int pathTicks = 0;
        class_1297 entity;
        int pathDuration;
        SplinePath path;

        PathData() {
        }
    }
}

