/*
 * Decompiled with CFR 0.152.
 */
package dev.doublekekse.map_utils.curve;

import dev.doublekekse.map_utils.curve.SplineControlPoint;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_3532;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record SplinePath(List<SplineControlPoint> controlPoints) {
    public static final class_9139<class_2540, SplinePath> STREAM_CODEC = class_9139.method_56434((class_9139)class_9135.method_56376(ArrayList::new, SplineControlPoint.STREAM_CODEC), SplinePath::controlPoints, SplinePath::new);

    public SplinePath {
        if (controlPoints == null || controlPoints.isEmpty()) {
            throw new IllegalArgumentException("At least one control point is required.");
        }
    }

    public class_243 getPosition(double progress) {
        if (this.controlPoints.size() == 1) {
            return this.controlPoints.getFirst().position();
        }
        int n = this.controlPoints.size() - 1;
        int startIndex = (int)Math.floor(progress * (double)n);
        startIndex = Math.max(0, Math.min(startIndex, n - 1));
        double u = progress * (double)n - (double)startIndex;
        class_243 p0 = startIndex > 0 ? this.controlPoints.get(startIndex - 1).position() : this.controlPoints.getFirst().position();
        class_243 p1 = this.controlPoints.get(startIndex).position();
        class_243 p2 = this.controlPoints.get(startIndex + 1).position();
        class_243 p3 = startIndex + 2 < this.controlPoints.size() ? this.controlPoints.get(startIndex + 2).position() : this.controlPoints.get(n).position();
        return SplinePath.interpolateCatmullRom(p0, p1, p2, p3, u);
    }

    public class_241 getRotation(double progress) {
        if (this.controlPoints.size() == 1) {
            return this.controlPoints.getFirst().rotation();
        }
        int numRotations = this.controlPoints.size();
        if (numRotations < 2) {
            throw new IllegalArgumentException("At least two rotations are needed for interpolation.");
        }
        int index0 = (int)Math.floor(progress * (double)(numRotations - 1));
        int index1 = Math.min(index0 + 1, numRotations - 1);
        double t = progress * (double)(numRotations - 1) - (double)index0;
        return SplinePath.lerpRotation(this.controlPoints.get(index0).rotation(), this.controlPoints.get(index1).rotation(), (float)t);
    }

    public static class_241 lerpRotation(class_241 start, class_241 end, float t) {
        return new class_241(class_3532.method_17821((float)t, (float)start.field_1343, (float)end.field_1343), class_3532.method_17821((float)t, (float)start.field_1342, (float)end.field_1342));
    }

    private static class_243 interpolateCatmullRom(class_243 p0, class_243 p1, class_243 p2, class_243 p3, double u) {
        double u2 = u * u;
        double u3 = u2 * u;
        double[] coefficients = new double[]{-0.5 * u3 + u2 - 0.5 * u, 1.5 * u3 - 2.5 * u2 + 1.0, -1.5 * u3 + 2.0 * u2 + 0.5 * u, 0.5 * u3 - 0.5 * u2};
        return new class_243(coefficients[0] * p0.field_1352 + coefficients[1] * p1.field_1352 + coefficients[2] * p2.field_1352 + coefficients[3] * p3.field_1352, coefficients[0] * p0.field_1351 + coefficients[1] * p1.field_1351 + coefficients[2] * p2.field_1351 + coefficients[3] * p3.field_1351, coefficients[0] * p0.field_1350 + coefficients[1] * p1.field_1350 + coefficients[2] * p2.field_1350 + coefficients[3] * p3.field_1350);
    }

    public int size() {
        return this.controlPoints.size();
    }

    public class_2499 write() {
        class_2499 tag = new class_2499();
        for (SplineControlPoint controlPoint : this.controlPoints) {
            tag.add((Object)controlPoint.write());
        }
        return tag;
    }

    public static SplinePath read(class_2499 tag) {
        ArrayList<SplineControlPoint> controlPoints = new ArrayList<SplineControlPoint>();
        for (class_2520 controlPointTag : tag) {
            controlPoints.add(SplineControlPoint.read((class_2487)controlPointTag));
        }
        return new SplinePath(controlPoints);
    }
}

