/*
 * Decompiled with CFR 0.152.
 */
package dev.doublekekse.map_utils.data;

import com.mojang.serialization.Codec;
import dev.doublekekse.map_utils.curve.SplinePath;
import dev.doublekekse.map_utils.duck.InventoryDuck;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_10741;
import net.minecraft.class_11343;
import net.minecraft.class_11352;
import net.minecraft.class_11362;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1657;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_26;
import net.minecraft.class_7225;
import net.minecraft.class_8942;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public class MapUtilsSavedData
extends class_18 {
    public class_2487 inventories = new class_2487();
    public Map<String, List<class_2487>> pets = new HashMap<String, List<class_2487>>();
    public Map<String, SplinePath> paths = new HashMap<String, SplinePath>();
    public static final Codec<MapUtilsSavedData> CODEC = class_2487.field_25128.xmap(MapUtilsSavedData::load, MapUtilsSavedData::save);
    private static final class_10741<MapUtilsSavedData> TYPE = new class_10741("map_utils", MapUtilsSavedData::new, CODEC, null);

    public void setPets(String id, List<class_2487> pets) {
        this.pets.put(id, pets);
    }

    public List<class_2487> getPets(String id) {
        return this.pets.get(id);
    }

    public void saveInventories(class_1657 player, String id, boolean remove) {
        class_11362 inventory = class_11362.method_71459((class_8942)class_8942.field_60348, (class_7225.class_7874)player.method_37908().method_30349());
        player.method_31548().method_7384(inventory.method_71467("minecraft:inventory", class_11343.field_60354));
        ((InventoryDuck)player.method_31548()).mapUtils$saveEquipment((class_11372.class_11373<class_11343>)inventory.method_71467("minecraft:equipment", class_11343.field_60354));
        if (remove) {
            player.method_31548().method_5448();
        }
        this.inventories.method_10566(id, (class_2520)inventory.method_71475());
        this.method_80();
    }

    public boolean loadInventories(class_1657 player, String id, boolean remove) {
        class_2520 tag = this.inventories.method_10580(id);
        if (tag == null || tag.method_68571().isEmpty()) {
            return false;
        }
        class_11368 inventory = class_11352.method_71417((class_8942)class_8942.field_60348, (class_7225.class_7874)player.method_37908().method_30349(), (class_2487)((class_2487)tag.method_68571().get()));
        inventory.method_71435("minecraft:inventory", class_11343.field_60354).ifPresent(itemStackWithSlots -> player.method_31548().method_7397(itemStackWithSlots));
        inventory.method_71435("minecraft:equipment", class_11343.field_60354).ifPresent(itemStackWithSlots -> ((InventoryDuck)player.method_31548()).mapUtils$loadEquipment((class_11368.class_11369<class_11343>)itemStackWithSlots));
        if (remove) {
            this.inventories.method_10551(id);
            this.method_80();
        }
        return true;
    }

    @NotNull
    public class_2487 save() {
        class_2487 tag = new class_2487();
        tag.method_10566("inventories", (class_2520)this.inventories);
        tag.method_10566("paths", (class_2520)this.savePaths());
        tag.method_10566("pets", (class_2520)this.savePets());
        return tag;
    }

    private class_2487 savePets() {
        class_2487 tag = new class_2487();
        for (Map.Entry<String, List<class_2487>> entry : this.pets.entrySet()) {
            class_2499 listTag = new class_2499();
            listTag.addAll((Collection)entry.getValue());
            tag.method_10566(entry.getKey(), (class_2520)listTag);
        }
        return tag;
    }

    private void loadPets(class_2487 tag) {
        for (Map.Entry entry : tag.method_59874()) {
            class_2499 listTag = (class_2499)((class_2520)entry.getValue()).method_68592().get();
            ArrayList list = new ArrayList(listTag);
            this.pets.put((String)entry.getKey(), list);
        }
    }

    public class_2487 savePaths() {
        class_2487 tag = new class_2487();
        for (Map.Entry<String, SplinePath> entry : this.paths.entrySet()) {
            tag.method_10566(entry.getKey(), (class_2520)entry.getValue().write());
        }
        return tag;
    }

    public void loadPaths(class_2487 pathsTag) {
        for (Map.Entry entry : pathsTag.method_59874()) {
            class_2499 list = (class_2499)((class_2520)entry.getValue()).method_68592().get();
            this.paths.put((String)entry.getKey(), SplinePath.read(list));
        }
    }

    public static MapUtilsSavedData load(class_2487 compoundTag) {
        MapUtilsSavedData data = new MapUtilsSavedData();
        data.inventories = (class_2487)compoundTag.method_10562("inventories").get();
        data.loadPaths((class_2487)compoundTag.method_10562("paths").get());
        data.loadPets((class_2487)compoundTag.method_10562("pets").get());
        return data;
    }

    public static MapUtilsSavedData getServerData(MinecraftServer server) {
        class_26 persistentStateManager = server.method_30002().method_17983();
        MapUtilsSavedData data = (MapUtilsSavedData)persistentStateManager.method_17924(TYPE);
        data.method_80();
        return data;
    }
}

