/*
 * Decompiled with CFR 0.152.
 */
package dev.doublekekse.map_utils.gizmo;

import dev.doublekekse.map_utils.gizmo.GizmoAxis;
import dev.doublekekse.map_utils.gizmo.GizmoTransformation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_863;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class Gizmo {
    public class_243 position;
    public Consumer<class_243> onPositionChange;
    public Supplier<class_243> getPosition;

    public static Gizmo bind(Supplier<class_243> getPosition, Consumer<class_243> onChange) {
        Gizmo gizmo = new Gizmo();
        gizmo.getPosition = getPosition;
        gizmo.onPositionChange = onChange;
        gizmo.position = getPosition.get();
        return gizmo;
    }

    public void scroll(class_2350 direction, double value) {
        class_243 offset = direction.method_62676().method_1021(0.1 * value);
        this.move(offset);
    }

    public void move(class_243 offset) {
        this.position = this.position.method_1019(offset);
        this.onPositionChange.accept(this.position);
    }

    void drawLine(WorldRenderContext ctx, class_4587.class_4665 pose, Vector3f offset, int color) {
        Vector3f normal = ctx.camera().method_19335().mul(-1.0f);
        class_4588 lineConsumer = ctx.consumers().getBuffer((class_1921)class_1921.field_21695);
        Vector3f fPos = this.position.method_46409();
        lineConsumer.method_61032(pose, fPos).method_39415(color).method_60831(pose, normal.x, normal.y, normal.z);
        lineConsumer.method_61032(pose, fPos.add((Vector3fc)offset)).method_39415(color).method_60831(pose, normal.x, normal.y, normal.z);
    }

    public class_238 getAABB() {
        double radius = 0.1;
        return new class_238(this.position.field_1352 - radius, this.position.field_1351 - radius, this.position.field_1350 - radius, this.position.field_1352 + radius, this.position.field_1351 + radius, this.position.field_1350 + radius);
    }

    public Collection<GizmoAxis> getAxes() {
        ArrayList<GizmoAxis> list = new ArrayList<GizmoAxis>(3);
        list.add(new GizmoAxis(this, new class_243(1.0, 0.0, 0.0), -65536));
        list.add(new GizmoAxis(this, new class_243(0.0, 1.0, 0.0), -16711936));
        list.add(new GizmoAxis(this, new class_243(0.0, 0.0, 1.0), -16776961));
        return list;
    }

    public Optional<GizmoTransformation> transformation(class_243 pos, class_243 end) {
        return this.getAABB().method_992(pos, end).map(intersection -> GizmoTransformation.of(this, null, intersection, pos));
    }

    public void render(WorldRenderContext ctx, boolean isActive) {
        class_4587 poseStack = ctx.matrixStack();
        class_4587.class_4665 pose = poseStack.method_23760();
        class_238 aabb = this.getAABB();
        class_863.method_23102((class_4587)poseStack, (class_4597)ctx.consumers(), (class_238)aabb, (float)1.0f, (float)(isActive ? 0.0f : 1.0f), (float)1.0f, (float)1.0f);
        if (!isActive) {
            return;
        }
        for (GizmoAxis axis : this.getAxes()) {
            this.drawLine(ctx, pose, axis.dir().method_46409(), axis.color());
        }
    }
}

