/*
 * Decompiled with CFR 0.152.
 */
package dev.doublekekse.map_utils.gizmo;

import dev.doublekekse.map_utils.client.MapUtilsClient;
import dev.doublekekse.map_utils.curve.SplineControlPoint;
import dev.doublekekse.map_utils.curve.SplinePath;
import dev.doublekekse.map_utils.gizmo.Gizmo;
import dev.doublekekse.map_utils.gizmo.GizmoTransformation;
import dev.doublekekse.map_utils.packet.ServerboundModifyControlPointPacket;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_243;
import net.minecraft.class_8710;
import org.jetbrains.annotations.Nullable;

public class Gizmos {
    public static List<Gizmo> gizmos = new ArrayList<Gizmo>();
    @Nullable
    public static Gizmo selectedGizmo = null;
    @Nullable
    public static GizmoTransformation transformation = null;

    public static void render(WorldRenderContext ctx) {
        for (Gizmo gizmo : gizmos) {
            gizmo.render(ctx, gizmo == selectedGizmo);
        }
    }

    public static void update() {
        gizmos.clear();
        selectedGizmo = null;
        transformation = null;
        for (Map.Entry<String, SplinePath> entry : MapUtilsClient.clientSavedData.paths.entrySet()) {
            Gizmos.forPath(entry.getKey(), entry.getValue());
        }
    }

    public static void forPath(String id, SplinePath path) {
        List<SplineControlPoint> controlPoints = path.controlPoints();
        int i = 0;
        while (i < controlPoints.size()) {
            int finalI = i++;
            SplineControlPoint controlPoint = controlPoints.get(finalI);
            gizmos.add(Gizmo.bind(controlPoint::position, pos -> {
                SplineControlPoint newControlPoint = controlPoint.withPosition((class_243)pos);
                controlPoints.set(finalI, newControlPoint);
                ClientPlayNetworking.send((class_8710)new ServerboundModifyControlPointPacket(id, finalI, newControlPoint));
            }));
        }
    }
}

