/*
 * Decompiled with CFR 0.152.
 */
package dev.doublekekse.map_utils.mixin;

import dev.doublekekse.map_utils.curve.SplinePath;
import dev.doublekekse.map_utils.state.CameraOverrideState;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_4184;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_4184.class})
public abstract class CameraMixin {
    @Shadow
    private boolean field_18719;
    @Shadow
    private class_243 field_18712;
    @Unique
    class_243 oldCameraPosition;
    @Unique
    class_241 oldCameraRotation;
    @Unique
    float lastTimeSinceLastTick;
    @Unique
    private static class_243 overridePosition;
    @Unique
    private static class_241 overrideRotation;

    @Shadow
    protected abstract void method_19322(class_243 var1);

    @Shadow
    protected abstract void method_19325(float var1, float var2);

    @Shadow
    public abstract float method_19329();

    @Shadow
    public abstract float method_19330();

    @Inject(method={"setup"}, at={@At(value="TAIL")})
    void setup(class_1922 blockGetter, class_1297 entity, boolean bl, boolean bl2, float timeSinceLastTick, CallbackInfo ci) {
        this.lastTimeSinceLastTick = timeSinceLastTick;
        this.tickPath(timeSinceLastTick);
        this.tickPosition(timeSinceLastTick);
        this.tickRotation(timeSinceLastTick);
    }

    @Unique
    void tickRotation(float timeSinceLastTick) {
        if (overrideRotation == null) {
            return;
        }
        this.method_19325(CameraMixin.overrideRotation.field_1343, CameraMixin.overrideRotation.field_1342);
        if (CameraOverrideState.interpolateRotation) {
            class_241 newRotation = SplinePath.lerpRotation(this.oldCameraRotation, overrideRotation, timeSinceLastTick);
            this.method_19325(newRotation.field_1343, newRotation.field_1342);
        } else {
            this.method_19325(CameraMixin.overrideRotation.field_1343, CameraMixin.overrideRotation.field_1342);
        }
    }

    @Unique
    void tickPosition(float timeSinceLastTick) {
        if (overridePosition == null) {
            return;
        }
        this.field_18719 = true;
        if (CameraOverrideState.interpolatePosition) {
            class_243 newPosition = this.oldCameraPosition.method_35590(overridePosition, (double)timeSinceLastTick);
            this.method_19322(newPosition);
        } else {
            this.method_19322(overridePosition);
        }
    }

    @Unique
    void tickPath(float timeSinceLastTick) {
        if (!this.isFollowingPath()) {
            return;
        }
        float progress = ((float)CameraOverrideState.splineTicks + timeSinceLastTick) / (float)CameraOverrideState.splineDuration;
        if (progress > 1.0f) {
            this.stopPath();
            return;
        }
        overridePosition = CameraOverrideState.spline.getPosition(progress);
        overrideRotation = CameraOverrideState.spline.getRotation(progress);
    }

    @Unique
    void stopPath() {
        CameraOverrideState.spline = null;
        CameraOverrideState.splineDuration = 1;
        CameraOverrideState.fov = -1.0f;
    }

    @Unique
    boolean isFollowingPath() {
        return CameraOverrideState.spline != null;
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    void tick(CallbackInfo ci) {
        this.lastTimeSinceLastTick = 0.0f;
        this.oldCameraPosition = overridePosition;
        this.oldCameraRotation = overrideRotation;
        overridePosition = CameraOverrideState.position;
        overrideRotation = CameraOverrideState.rotation;
        if (this.oldCameraPosition == null) {
            this.oldCameraPosition = this.field_18712;
        }
        if (this.oldCameraRotation == null) {
            this.oldCameraRotation = new class_241(this.method_19329(), this.method_19330());
        }
        ++CameraOverrideState.splineTicks;
    }
}

