/*
 * Decompiled with CFR 0.152.
 */
package dev.doublekekse.map_utils.timer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.doublekekse.map_utils.compat.player_roles.PlayerRoleCompatibility;
import dev.doublekekse.map_utils.utils.AdditionalCodecs;
import java.util.Optional;
import java.util.UUID;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2165;
import net.minecraft.class_2168;
import net.minecraft.class_234;
import net.minecraft.class_236;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record CommandCallback(class_5321<class_1937> dimension, @NotNull Optional<UUID> entityUUID, String command, class_243 position, class_241 rotation, int permissionLevel) implements class_234<MinecraftServer>
{
    public static final MapCodec<CommandCallback> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_5321.method_39154((class_5321)class_7924.field_41223).fieldOf("dimension").forGetter(CommandCallback::dimension), (App)AdditionalCodecs.UUID_CODEC.optionalFieldOf("entity_uuid").forGetter(CommandCallback::entityUUID), (App)Codec.STRING.fieldOf("command").forGetter(CommandCallback::command), (App)class_243.field_38277.fieldOf("position").forGetter(CommandCallback::position), (App)class_241.field_56695.fieldOf("rotation").forGetter(CommandCallback::rotation), (App)Codec.INT.fieldOf("permission_level").forGetter(CommandCallback::permissionLevel)).apply((Applicative)instance, CommandCallback::new));

    public void handle(MinecraftServer minecraftServer, class_236<MinecraftServer> timerQueue, long l) {
        class_3218 level = minecraftServer.method_3847(this.dimension);
        if (level == null) {
            return;
        }
        class_1297 entity = this.entityUUID.isEmpty() ? null : level.method_66347(this.entityUUID.get());
        minecraftServer.method_3734().method_44252(this.createCommandSourceStack(entity, level), this.command);
    }

    private class_2168 createCommandSourceStack(@Nullable class_1297 entity, class_3218 level) {
        String name = entity == null ? "CommandCallback" : entity.method_5477().getString() + " (CommandCallback)";
        class_5250 nameComponent = class_2561.method_43470((String)name);
        if (entity != null) {
            class_2561 displayName = entity.method_5476();
            displayName.method_27661().method_27693(" (CommandCallback)");
        }
        class_2168 stack = new class_2168(class_2165.field_17395, this.position, this.rotation, level, this.permissionLevel, name, (class_2561)nameComponent, level.method_8503(), entity);
        if (FabricLoader.getInstance().isModLoaded("player_roles")) {
            PlayerRoleCompatibility.applyCommandIdentityType(stack);
        }
        return stack;
    }

    @NotNull
    public MapCodec<CommandCallback> method_67704() {
        return CODEC;
    }
}

