package dev.doublekekse.map_utils;

import dev.doublekekse.map_utils.data.MapUtilsSavedData;
import dev.doublekekse.map_utils.packet.*;
import dev.doublekekse.map_utils.registry.*;
import dev.doublekekse.map_utils.state.CameraOverrideState;
import dev.doublekekse.map_utils.timer.CommandCallback;
import dev.doublekekse.map_utils.timer.DeactivateBlockCallback;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_233;
import net.minecraft.class_2960;
import net.minecraft.server.MinecraftServer;

public class MapUtils implements ModInitializer {
    public static final String MOD_ID = "map_utils";

    public static void invalidateData(MinecraftServer server) {
        var savedData = MapUtilsSavedData.getServerData(server);
        savedData.method_80();

        for (var player : server.method_3760().method_14571()) {
            ServerPlayNetworking.send(player, new ClientboundSyncDataPacket(savedData));
        }
    }

    public static void syncData(PacketSender packetSender, MinecraftServer server) {
        var savedData = MapUtilsSavedData.getServerData(server);
        packetSender.sendPacket(new ClientboundSyncDataPacket(savedData));
    }

    @Override
    public void onInitialize() {
        CameraOverrideState.reset();

        class_233.field_1306.method_971(id("command_callback"), CommandCallback.CODEC);
        class_233.field_1306.method_971(id("deactivate_block_callback"), DeactivateBlockCallback.CODEC);

        MapUtilsBlocks.register();
        MapUtilsBlockEntities.register();
        MapUtilsCreativeTabs.register();
        MapUtilsPackets.register();
        MapUtilsCommands.register();

        ServerPlayConnectionEvents.JOIN.register((listener, packetSender, server) -> syncData(packetSender, server));
    }

    public static class_2960 id(String path) {
        return class_2960.method_60655(MOD_ID, path);
    }
}
