package dev.doublekekse.map_utils.block.timer;

import com.mojang.serialization.MapCodec;
import dev.doublekekse.map_utils.MapUtils;
import dev.doublekekse.map_utils.duck.PlayerDuck;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.world.level.block.entity.*;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import static dev.doublekekse.map_utils.registry.MapUtilsBlockEntities.TIMER_BLOCK_ENTITY;

public class TimerBlock extends class_2237 {
    public static final MapCodec<TimerBlock> CODEC = method_54094(TimerBlock::new);

    public TimerBlock(class_4970.class_2251 properties) {
        super(properties);
    }

    @Override
    protected @NotNull MapCodec<? extends class_2237> method_53969() {
        return field_46280;
    }

    @Nullable
    @Override
    public class_2586 method_10123(class_2338 blockPos, class_2680 blockState) {
        return new TimerBlockEntity(blockPos, blockState);
    }

    @Override
    protected @NotNull class_2464 method_9604(class_2680 blockState) {
        return class_2464.field_11458;
    }

    @Nullable
    @Override
    public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 blockState, class_2591<T> blockEntityType) {
        return method_31618(blockEntityType, TIMER_BLOCK_ENTITY, TimerBlockEntity::tick);
    }

    @Override
    protected int method_9524(class_2680 blockState, class_1922 blockGetter, class_2338 blockPos, class_2350 direction) {
        class_2586 blockEntity = blockGetter.method_8321(blockPos);
        return blockEntity instanceof TimerBlockEntity ? ((TimerBlockEntity) blockEntity).getOutputSignal() : 0;
    }

    @Override
    protected boolean method_9506(class_2680 blockState) {
        return true;
    }

    @Override
    protected @NotNull class_1269 method_55766(class_2680 blockState, class_1937 level, class_2338 blockPos, class_1657 player, class_3965 blockHitResult) {
        class_2586 blockEntity = level.method_8321(blockPos);
        if (player.method_7338() && blockEntity instanceof TimerBlockEntity tbe && player.method_7338()) {
            ((PlayerDuck) player).mapUtils$openTimerBlock(tbe);
            return class_1269.field_5812;
        } else {
            return class_1269.field_5811;
        }
    }
}
