package dev.doublekekse.map_utils.block.timer;

import dev.doublekekse.map_utils.MapUtils;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_7225;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import static dev.doublekekse.map_utils.registry.MapUtilsBlockEntities.TIMER_BLOCK_ENTITY;

public class TimerBlockEntity extends class_2586 {
    public int interval = 10;
    public int duration = 1;
    long tickData = 0;
    public boolean tickUnloaded = false;
    boolean enabled = false;

    public TimerBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(TIMER_BLOCK_ENTITY, blockPos, blockState);
    }

    @Override
    protected void method_11007(@NotNull class_11372 valueOutput) {
        super.method_11007(valueOutput);

        valueOutput.method_71465("interval", interval);
        valueOutput.method_71465("duration", duration);
        valueOutput.method_71466("tick_data", tickData);
        valueOutput.method_71472("tick_unloaded", tickUnloaded);
    }

    @Override
    protected void method_11014(@NotNull class_11368 valueInput) {
        super.method_11014(valueInput);

        interval = valueInput.method_71439("interval").orElse(10);
        duration = valueInput.method_71439("duration").orElse(1);
        tickData = valueInput.method_71440("tick_data").orElse(0L);
        tickUnloaded = valueInput.method_71433("tick_unloaded", false);
    }

    public void enable() {
        this.enabled = true;

        assert field_11863 != null;
        field_11863.method_8408(this.method_11016(), this.method_11010().method_26204());
        method_5431();
    }

    public void disable() {
        this.enabled = false;

        assert field_11863 != null;
        field_11863.method_8408(this.method_11016(), this.method_11010().method_26204());
        method_5431();
    }

    public static void tick(class_1937 level, class_2338 blockPos, class_2680 blockState, TimerBlockEntity instance) {
        if (level.field_9236) {
            return;
        }


        if (instance.tickUnloaded) {
            var currentTick = level.method_8510();

            if (instance.tickData + instance.interval <= currentTick) {
                instance.tickData = currentTick;
                instance.enable();
            }

            if (instance.tickData + instance.duration <= currentTick && instance.enabled) {
                instance.disable();
            }
        } else {
            instance.tickData++;

            if (instance.tickData >= instance.interval) {
                instance.tickData = 0;
                instance.enable();
            }

            if (instance.tickData == instance.duration) {
                instance.disable();
            }
        }
    }

    @Override
    public @Nullable class_2596<class_2602> method_38235() {
        return class_2622.method_38585(this);
    }

    @Override
    public @NotNull class_2487 method_16887(class_7225.class_7874 provider) {
        class_2487 compoundTag = new class_2487();

        compoundTag.method_10569("interval", interval);
        compoundTag.method_10569("duration", duration);
        compoundTag.method_10556("tick_unloaded", tickUnloaded);

        return compoundTag;
    }

    public int getOutputSignal() {
        return this.enabled ? 15 : 0;
    }
}
