package dev.doublekekse.map_utils.client.path;

import dev.doublekekse.map_utils.client.MapUtilsClient;
import dev.doublekekse.map_utils.curve.SplineControlPoint;
import dev.doublekekse.map_utils.curve.SplinePath;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_9974;
import org.joml.Vector3f;

public class PathRenderer {
    public static void render(WorldRenderContext ctx) {
        if (MapUtilsClient.clientSavedData == null) {
            return;
        }

        for (var entry : MapUtilsClient.clientSavedData.paths.entrySet()) {
            renderPath(ctx, entry.getValue(), entry.getKey());
        }
    }

    public static void renderPath(WorldRenderContext ctx, SplinePath path, String id) {
        var lineConsumer = ctx.consumers().getBuffer(class_1921.field_21695);
        var poseStack = ctx.matrixStack();
        var pose = poseStack.method_23760();
        var normal = ctx.camera().method_19335().mul(-1);

        renderLine(path, pose, lineConsumer, normal);

        for (var controlPoint : path.controlPoints()) {
            renderControlPointRotation(controlPoint, poseStack, lineConsumer, normal);
        }

        int index = 0;
        for (var controlPoint : path.controlPoints()) {
            renderControlPointText(controlPoint, id + ": " + index++, poseStack, ctx);
        }
    }

    static void renderLine(SplinePath path, class_4587.class_4665 pose, class_4588 lineConsumer, Vector3f normal) {
        var count = 20.0 * path.size();
        for (int i = 0; i < count; i++) {
            var currentProgress = i / count;
            var nextProgress = (i + 1) / count;

            var currentPos = path.getPosition(currentProgress);
            var nextPos = path.getPosition(nextProgress);

            lineConsumer.method_61032(pose, currentPos.method_46409()).method_39415(0xffffffff).method_60831(pose, normal.x, normal.y, normal.z);
            lineConsumer.method_61032(pose, nextPos.method_46409()).method_39415(0xffffffff).method_60831(pose, normal.x, normal.y, normal.z);
        }
    }

    static void renderControlPointRotation(SplineControlPoint controlPoint, class_4587 poseStack, class_4588 lineConsumer, Vector3f normal) {
        var rotation = controlPoint.rotation();

        float yaw = (float) Math.toRadians(rotation.field_1343 + 90);
        float pitch = (float) Math.toRadians(-rotation.field_1342);

        float dx = (float) (Math.cos(yaw) * Math.cos(pitch));
        float dy = (float) Math.sin(pitch);
        float dz = (float) (Math.sin(yaw) * Math.cos(pitch));


        class_9974.method_62298(poseStack, lineConsumer, controlPoint.position().method_46409(), new class_243(dx, dy, dz), 0xffffff00);
        //lineConsumer.addVertex(pose, controlPoint.position().toVector3f()).setColor(0xffffff00).setNormal(normal.x, normal.y, normal.z);
        //lineConsumer.addVertex(pose, controlPoint.position().add(dx, dy, dz).toVector3f()).setColor(0xffffff00).setNormal(normal.x, normal.y, normal.z);
    }

    static void renderControlPointText(SplineControlPoint controlPoint, String text, class_4587 poseStack, WorldRenderContext ctx) {
        poseStack.method_22903();
        poseStack.method_22904(controlPoint.position().field_1352, controlPoint.position().field_1351, controlPoint.position().field_1350);
        poseStack.method_22907(ctx.camera().method_23767().mul(-1));
        poseStack.method_22905(.01f, -.01f, .01f);

        var font = class_310.method_1551().field_1772;
        var width = font.method_1727(text);
        font.method_27521(text, -width / 2f, -30, 0xffffffff, false, poseStack.method_23760().method_23761(), ctx.consumers(), class_327.class_6415.field_33995, 0, 0xf000f0);

        poseStack.method_22909();
    }
}
