package dev.doublekekse.map_utils.client.screen;

import dev.doublekekse.map_utils.block.timer.TimerBlockEntity;
import dev.doublekekse.map_utils.packet.SetTimerBlockPacket;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_4286;
import net.minecraft.class_437;
import net.minecraft.class_7919;

public class TimerEditScreen extends class_437 {
    int duration;
    int interval;
    boolean tickUnloaded;

    class_342 durationInput;
    class_342 intervalInput;
    class_4286 tickUnloadedCheckbox;

    TimerBlockEntity blockEntity;

    public TimerEditScreen(TimerBlockEntity timerBlockEntity) {
        super(class_2561.method_43471("gui.map_utils.screen.timer_edit"));

        duration = timerBlockEntity.duration;
        interval = timerBlockEntity.interval;
        tickUnloaded = timerBlockEntity.tickUnloaded;

        blockEntity = timerBlockEntity;
    }

    void sendToServer() {
        ClientPlayNetworking.send(new SetTimerBlockPacket(
            blockEntity.method_11016(),
            parseAsInt(durationInput.method_1882()),
            parseAsInt(intervalInput.method_1882()),
            tickUnloadedCheckbox.method_20372()
        ));
    }

    private int parseAsInt(String string) {
        try {
            return Integer.parseInt(string);
        } catch (NumberFormatException e) {
            return 0;
        }
    }

    @Override
    public void method_25419() {
        super.method_25419();

        sendToServer();
    }

    @Override
    protected void method_25426() {
        super.method_25426();


        assert field_22787 != null;

        durationInput = new class_342(field_22787.field_1772, this.field_22789 / 2 - 100, 20, 200, 20, class_2561.method_43471("gui.map_utils.timer.duration"));
        durationInput.method_1852(String.valueOf(duration));
        intervalInput = new class_342(field_22787.field_1772, this.field_22789 / 2 - 100, 60, 200, 20, class_2561.method_43471("gui.map_utils.timer.interval"));
        intervalInput.method_1852(String.valueOf(interval));
        tickUnloadedCheckbox = class_4286.method_54787(class_2561.method_43471("gui.map_utils.timer.tick_unloaded"), field_22787.field_1772).method_54789(this.field_22789 / 2 - 100, 100).method_54794(tickUnloaded).method_54788();
        tickUnloadedCheckbox.method_47400(class_7919.method_47407(class_2561.method_43471("gui.map_utils.timer.tick_unloaded.tooltip")));

        method_37063(durationInput);
        method_37063(intervalInput);
        method_37063(tickUnloadedCheckbox);
    }

    @Override
    public void method_25394(class_332 graphics, int x, int y, float pTicks) {
        super.method_25394(graphics, x, y, pTicks);

        graphics.method_27535(this.field_22793, class_2561.method_43471("gui.map_utils.timer.duration.label"), this.field_22789 / 2 - 100, 10, 10526880);
        graphics.method_27535(this.field_22793, class_2561.method_43471("gui.map_utils.timer.interval.label"), this.field_22789 / 2 - 100, 50, 10526880);
        graphics.method_27535(this.field_22793, class_2561.method_43471("gui.map_utils.timer.tick_unloaded.label"), this.field_22789 / 2 - 100, 90, 10526880);
    }
}
