package dev.doublekekse.map_utils.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import net.minecraft.class_2168;
import net.minecraft.class_2186;
import net.minecraft.class_2277;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

public class AccelerateCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register(method_9247("accelerate").then(method_9244("entity", class_2186.method_9309()).then(method_9247("towards").then(method_9244("target", class_2186.method_9309()).then(method_9244("force", DoubleArgumentType.doubleArg(-.9, .9)).executes(ctx -> {
            var entity = class_2186.method_9313(ctx, "entity");
            var target = class_2186.method_9313(ctx, "target");
            var force = DoubleArgumentType.getDouble(ctx, "force");

            var delta = target.method_19538().method_1020(entity.method_19538()).method_1021(force);

            // Max acceleration just in case
            if (delta.method_1027() > 9) {
                delta = delta.method_1021(3 / delta.method_1033());
            }

            entity.method_45319(delta);

            return 1;
        }).then(method_9247("normalized").executes(ctx -> {
            var entity = class_2186.method_9313(ctx, "entity");
            var target = class_2186.method_9313(ctx, "target");
            var force = DoubleArgumentType.getDouble(ctx, "force");

            var delta = target.method_19538().method_1020(entity.method_19538()).method_1029().method_1021(force);

            entity.method_45319(delta);

            return 1;
        }))))).then(method_9244("delta", class_2277.method_9735(false)).executes(ctx -> {
            var entity = class_2186.method_9313(ctx, "entity");
            var delta = class_2277.method_9736(ctx, "delta");

            // Max acceleration just in case
            if (delta.method_1027() > 9) {
                delta = delta.method_1021(3 / delta.method_1033());
            }

            entity.method_45319(delta);

            return 1;
        }))));
    }
}
