package dev.doublekekse.map_utils.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import dev.doublekekse.map_utils.command.argument.PathArgumentType;
import dev.doublekekse.map_utils.packet.*;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2168;
import net.minecraft.class_2245;
import net.minecraft.class_2270;
import net.minecraft.class_2277;
import net.minecraft.class_241;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

public class CameraCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {

        dispatcher.register(
            method_9247("camera")
                .then(method_9247("fov").requires(source -> source.method_9259(2))
                    .then(method_9247("reset").executes(context -> {
                        if (context.getSource().method_44023() == null) {
                            context.getSource().method_9213(class_2561.method_43471("commands.map_utils.camera.no_player"));
                            return -1;
                        }

                        ServerPlayNetworking.send(context.getSource().method_44023(), new CameraFovPacket(-1));
                        context.getSource().method_9226(() -> class_2561.method_43471("commands.map_utils.camera.fov.reset"), false);

                        return 1;
                    })).then(method_9247("set").then(method_9244("fov", FloatArgumentType.floatArg()).executes((context -> {
                        var fov = FloatArgumentType.getFloat(context, "fov");

                        if (context.getSource().method_44023() == null) {
                            context.getSource().method_9213(class_2561.method_43471("commands.map_utils.camera.no_player"));
                            return -1;
                        }

                        ServerPlayNetworking.send(context.getSource().method_44023(), new CameraFovPacket(fov));
                        context.getSource().method_9226(() -> class_2561.method_43469("commands.map_utils.camera.fov.set", fov), false);

                        return 1;
                    }))))
                ).then(method_9247("overlay").requires(source -> source.method_9259(2))
                    .then(method_9247("reset").executes(context -> {
                        if (context.getSource().method_44023() == null) {
                            context.getSource().method_9213(class_2561.method_43471("commands.map_utils.camera.no_player"));
                            return -1;
                        }

                        ServerPlayNetworking.send(context.getSource().method_44023(), new CameraOverlayPacket(null, 0));
                        context.getSource().method_9226(() -> class_2561.method_43471("commands.map_utils.camera.overlay.reset"), false);

                        return 1;
                    })).then(method_9247("set").then(method_9244("overlayTexture", StringArgumentType.string()).then(method_9244("overlayOpacity", FloatArgumentType.floatArg(0, 1)).executes(context -> {
                        var overlayLocation = class_2960.method_60654(StringArgumentType.getString(context, "overlayTexture"));
                        var overlayOpacity = FloatArgumentType.getFloat(context, "overlayOpacity");

                        if (context.getSource().method_44023() == null) {
                            context.getSource().method_9213(class_2561.method_43471("commands.map_utils.camera.no_player"));
                            return -1;
                        }

                        ServerPlayNetworking.send(context.getSource().method_44023(), new CameraOverlayPacket(overlayLocation, overlayOpacity));
                        context.getSource().method_9226(() -> class_2561.method_43469("commands.map_utils.camera.overlay.set", overlayLocation.toString(), overlayOpacity), false);

                        return 1;
                    }))))
                ).then(method_9247("position").requires(source -> source.method_9259(2))
                    .then(method_9247("reset").executes(context -> {
                        if (context.getSource().method_44023() == null) {
                            context.getSource().method_9226(() -> class_2561.method_43471("commands.map_utils.camera.no_player"), false);
                            return -1;
                        }

                        ServerPlayNetworking.send(context.getSource().method_44023(), new CameraPositionPacket(null, false));
                        context.getSource().method_9226(() -> class_2561.method_43471("commands.map_utils.camera.position.reset"), false);

                        return 1;
                    })).then(method_9247("set").then(method_9244("position", class_2277.method_9737()).then(method_9244("interpolate", BoolArgumentType.bool()).executes(context -> {
                        var position = class_2277.method_9736(context, "position");
                        var interpolate = BoolArgumentType.getBool(context, "interpolate");

                        if (context.getSource().method_44023() == null) {
                            context.getSource().method_9213(class_2561.method_43471("commands.map_utils.camera.no_player"));
                            return -1;
                        }

                        ServerPlayNetworking.send(context.getSource().method_44023(), new CameraPositionPacket(position, interpolate));
                        context.getSource().method_9226(() -> class_2561.method_43469("commands.map_utils.camera.position.set", position.field_1352, position.field_1351, position.field_1350), false);

                        return 1;
                    }))))
                ).then(method_9247("rotation").requires(source -> source.method_9259(2))
                    .then(method_9247("reset").executes(context -> {
                        if (context.getSource().method_44023() == null) {
                            context.getSource().method_9213(class_2561.method_43471("commands.map_utils.camera.no_player"));
                            return -1;
                        }

                        ServerPlayNetworking.send(context.getSource().method_44023(), new CameraRotationPacket(null, false));
                        context.getSource().method_9226(() -> class_2561.method_43471("commands.map_utils.camera.rotation.reset"), false);

                        return 1;
                    })).then(method_9247("set").then(method_9244("rotation", class_2270.method_9717()).then(method_9244("interpolate", BoolArgumentType.bool()).executes(context -> {
                        var rotation = class_2270.method_9716(context, "rotation").method_9709(context.getSource());
                        var interpolate = BoolArgumentType.getBool(context, "interpolate");

                        if (context.getSource().method_44023() == null) {
                            context.getSource().method_9213(class_2561.method_43471("commands.map_utils.camera.no_player"));
                            return -1;
                        }

                        // y and x are flipped for some reason
                        ServerPlayNetworking.send(context.getSource().method_44023(), new CameraRotationPacket(new class_241(rotation.field_1342, rotation.field_1343), interpolate));
                        context.getSource().method_9226(() -> class_2561.method_43469("commands.map_utils.camera.rotation.set", rotation.field_1342, rotation.field_1343), false);

                        return 1;
                    }))))
                ).then(method_9247("path").requires(source -> source.method_9259(2))
                    .then(method_9247("reset").executes(context -> {
                        if (context.getSource().method_44023() == null) {
                            context.getSource().method_9213(class_2561.method_43471("commands.map_utils.camera.no_player"));
                            return -1;
                        }

                        ServerPlayNetworking.send(context.getSource().method_44023(), new CameraSplinePacket(null, 1));
                        context.getSource().method_9226(() -> class_2561.method_43471("commands.map_utils.camera.path.reset"), false);

                        return 1;
                    })).then(method_9247("set").then(method_9244("duration", class_2245.method_48287(1)).then(method_9244("path", PathArgumentType.path()).executes(context -> {
                        var path = PathArgumentType.getPath(context, "path");
                        var pathId = PathArgumentType.getPathId(context, "path");
                        var duration = IntegerArgumentType.getInteger(context, "duration");

                        if (path == null) {
                            context.getSource().method_9213(class_2561.method_43471("commands.map_utils.path.not_found"));
                            return -1;
                        }

                        if (context.getSource().method_44023() == null) {
                            context.getSource().method_9213(class_2561.method_43471("commands.map_utils.camera.no_player"));
                            return -1;
                        }

                        ServerPlayNetworking.send(context.getSource().method_44023(), new CameraSplinePacket(pathId, duration));
                        context.getSource().method_9226(() -> class_2561.method_43469("commands.map_utils.camera.path.set", path.size(), duration), false);

                        return 1;
                    }))))
                ).then(method_9247("reset").executes(context -> {
                        if (context.getSource().method_44023() == null) {
                            context.getSource().method_9213(class_2561.method_43471("commands.map_utils.camera.no_player"));
                            return -1;
                        }

                        resetCamera(context.getSource().method_44023());

                        context.getSource().method_9226(() -> class_2561.method_43471("commands.map_utils.camera.reset_all"), false);
                        return 1;
                    })
                ));
    }

    public static void resetCamera(class_3222 player) {
        ServerPlayNetworking.send(player, new CameraPositionPacket(null, false));
        ServerPlayNetworking.send(player, new CameraRotationPacket(null, false));
        ServerPlayNetworking.send(player, new CameraSplinePacket(null, 1));
        ServerPlayNetworking.send(player, new CameraOverlayPacket(null, 0));
        ServerPlayNetworking.send(player, new CameraFovPacket(-1));
    }
}