package dev.doublekekse.map_utils.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.doublekekse.map_utils.packet.ClickEventPacket;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2168;
import net.minecraft.class_2186;
import net.minecraft.class_2558;
import net.minecraft.class_2561;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

public class ClickEventCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        var openUrl = method_9244("player", class_2186.method_9305()).then(method_9244("value", StringArgumentType.greedyString()).executes(context -> handle(context, class_2558.class_2559.field_11749)));
        var openFile = method_9244("player", class_2186.method_9305()).then(method_9244("value", StringArgumentType.greedyString()).executes(context -> handle(context, class_2558.class_2559.field_11746)));
        var suggestCommand = method_9244("player", class_2186.method_9305()).then(method_9244("value", StringArgumentType.greedyString()).executes(context -> handle(context, class_2558.class_2559.field_11745)));
        var copy = method_9244("player", class_2186.method_9305()).then(method_9244("value", StringArgumentType.greedyString()).executes(context -> handle(context, class_2558.class_2559.field_21462)));

        dispatcher.register(
            method_9247("clickevent").requires(source -> source.method_9259(2))
                .then(method_9247("open_url").then(openUrl))
                .then(method_9247("open_file").then(openFile))
                .then(method_9247("suggest_command").then(suggestCommand))
                .then(method_9247("copy_to_clipboard").then(copy))
        );
    }

    public static int handle(CommandContext<class_2168> context, class_2558.class_2559 action) throws CommandSyntaxException {
        var value = StringArgumentType.getString(context, "value");
        var player = class_2186.method_9315(context, "player");

        ServerPlayNetworking.send(player, new ClickEventPacket(action, value));
        context.getSource().method_9226(() -> class_2561.method_43471("commands.clickevent.success"), true);

        return 1;
    }
}
