package dev.doublekekse.map_utils.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import dev.doublekekse.map_utils.data.MapUtilsSavedData;
import net.minecraft.class_2168;
import net.minecraft.class_2186;
import net.minecraft.class_2561;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

public class InventoryCommand {

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register(
            method_9247("inv").requires(source -> source.method_9259(2))
                .then(method_9247("save").then(method_9244("player", class_2186.method_9305()).then(method_9244("save", StringArgumentType.string()).then(method_9244("remove", BoolArgumentType.bool()).executes(context -> {
                        var save = StringArgumentType.getString(context, "save");
                        var isGlobal = save.charAt(0) == '+';
                        var player = class_2186.method_9315(context, "player");
                        var data = MapUtilsSavedData.getServerData(context.getSource().method_9211());
                        var remove = BoolArgumentType.getBool(context, "remove");

                        if (!isGlobal) {
                            save = player.method_5845() + "-" + save;
                        }

                        data.saveInventories(player, save, remove);

                        String finalSave = save;
                        context.getSource().method_9226(() -> class_2561.method_43469("commands.map_utils.inventory.saved", finalSave), false);

                        return 1;
                    }
                ))))).then(method_9247("load").then(method_9244("player", class_2186.method_9305()).then(method_9244("save", StringArgumentType.string()).then(method_9244("remove", BoolArgumentType.bool()).executes(context -> {
                    var save = StringArgumentType.getString(context, "save");
                    var isGlobal = save.charAt(0) == '+';
                    var player = class_2186.method_9315(context, "player");
                    var data = MapUtilsSavedData.getServerData(context.getSource().method_9211());
                    var remove = BoolArgumentType.getBool(context, "remove");

                    if (!isGlobal) {
                        save = player.method_5845() + "-" + save;
                    }
                    String finalSave = save;

                    var invResult = data.loadInventories(player, save, remove);

                    if (!invResult) {
                        context.getSource().method_9213(class_2561.method_43469("commands.map_utils.inventory.missing", finalSave));
                        return -1;
                    }

                    context.getSource().method_9226(() -> class_2561.method_43469("commands.map_utils.inventory.loaded", finalSave), false);

                    return 1;
                }))))).then(method_9247("list").executes(ctx -> {
                    var source = ctx.getSource();
                    var data = MapUtilsSavedData.getServerData(source.method_9211());

                    source.method_9226(() -> class_2561.method_43471("commands.map_utils.inventory.list"), false);

                    for (var key : data.inventories.method_10541()) {
                        source.method_9226(() -> class_2561.method_43470(key), false);
                    }

                    return 1;
                })
        ));
    }
}
