package dev.doublekekse.map_utils.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import dev.doublekekse.map_utils.MapUtils;
import dev.doublekekse.map_utils.command.argument.PathArgumentType;
import dev.doublekekse.map_utils.curve.SplineControlPoint;
import dev.doublekekse.map_utils.curve.SplinePath;
import dev.doublekekse.map_utils.data.MapUtilsSavedData;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2186;
import net.minecraft.class_2245;
import net.minecraft.class_241;
import net.minecraft.class_2561;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

public class PathCommand {
    static class PathData {
        int pathTicks = 0;

        class_1297 entity;
        int pathDuration;
        SplinePath path;
    }

    static List<PathData> list = new ArrayList<>();

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register(
            method_9247("path").requires(source -> source.method_9259(2))
                .then(method_9247("apply").then(method_9244("entity", class_2186.method_9309()).then(method_9244("duration", class_2245.method_48287(1)).then(method_9244("path", PathArgumentType.path()).executes(ctx -> {
                    var entity = class_2186.method_9313(ctx, "entity");
                    var path = PathArgumentType.getPath(ctx, "path");
                    var duration = IntegerArgumentType.getInteger(ctx, "duration");

                    if (path == null) {
                        ctx.getSource().method_9213(class_2561.method_43471("commands.map_utils.path.not_found"));
                        return -1;
                    }

                    var data = new PathData();

                    data.entity = entity;
                    data.path = path;
                    data.pathDuration = duration;

                    list.add(data);

                    ctx.getSource().method_9226(() -> class_2561.method_43469("commands.map_utils.path.apply.success", duration), false);

                    return 1;
                }))))).then(method_9247("cancel").then(method_9244("entity", class_2186.method_9309()).executes(ctx -> {
                    var entity = class_2186.method_9313(ctx, "entity");

                    list.removeIf(data -> data.entity == entity);

                    return 1;
                }))).then(method_9247("list").executes(ctx -> {
                    var source = ctx.getSource();
                    var savedData = MapUtilsSavedData.getServerData(source.method_9211());
                    var ids = savedData.paths.keySet();

                    source.method_9226(() -> class_2561.method_43470(String.join(", ", ids)), false);

                    return 1;
                })).then(method_9247("create").then(method_9244("id", StringArgumentType.string()).executes(ctx -> {
                    var source = ctx.getSource();
                    var server = source.method_9211();
                    var id = StringArgumentType.getString(ctx, "id");
                    var entity = source.method_9228();

                    if (entity == null) {
                        ctx.getSource().method_9213(class_2561.method_43471("commands.map_utils.no_entity"));
                        return -1;
                    }

                    var pos = entity.method_33571();
                    var rotation = source.method_9210();

                    var controlPoints = new ArrayList<SplineControlPoint>();
                    controlPoints.add(new SplineControlPoint(pos, new class_241(rotation.field_1342, rotation.field_1343)));

                    var savedData = MapUtilsSavedData.getServerData(server);

                    if (savedData.paths.containsKey(id)) {
                        ctx.getSource().method_9213(class_2561.method_43471("commands.map_utils.path.create.already_exists"));
                        return -1;
                    }

                    savedData.paths.put(id, new SplinePath(controlPoints));

                    MapUtils.invalidateData(server);

                    ctx.getSource().method_9226(() -> class_2561.method_43471("commands.map_utils.path.create.success"), false);

                    return 1;
                }))).then(method_9247("delete").then(method_9244("id", PathArgumentType.path()).executes(ctx -> {
                    var source = ctx.getSource();
                    var server = source.method_9211();
                    var path = PathArgumentType.getPath(ctx, "id");
                    var pathId = PathArgumentType.getPathId(ctx, "id");

                    if (path == null) {
                        ctx.getSource().method_9213(class_2561.method_43471("commands.map_utils.path.not_found"));
                        return -1;
                    }

                    var savedData = MapUtilsSavedData.getServerData(server);
                    savedData.paths.remove(pathId);
                    MapUtils.invalidateData(server);

                    ctx.getSource().method_9226(() -> class_2561.method_43469("commands.map_utils.path.delete.success", pathId), true);

                    return 1;
                }))).then(method_9247("edit")
                    .then(method_9244("path", PathArgumentType.path()).then(method_9247("add").executes(ctx -> {
                        var source = ctx.getSource();
                        var entity = source.method_9228();

                        if (entity == null) {
                            ctx.getSource().method_9213(class_2561.method_43471("commands.map_utils.no_entity"));
                            return -1;
                        }

                        var pos = entity.method_33571();
                        var rotation = source.method_9210();
                        var path = PathArgumentType.getPath(ctx, "path");

                        if (path == null) {
                            ctx.getSource().method_9213(class_2561.method_43471("commands.map_utils.path.not_found"));
                            return -1;
                        }

                        var controlPoints = path.controlPoints();
                        controlPoints.add(new SplineControlPoint(pos, new class_241(rotation.field_1342, rotation.field_1343)));
                        MapUtils.invalidateData(source.method_9211());

                        ctx.getSource().method_9226(() -> class_2561.method_43471("commands.map_utils.path.edit.add.success"), false);

                        return 1;
                    })).then(method_9247("insert").then(method_9244("before", IntegerArgumentType.integer(0)).executes(ctx -> {
                        var source = ctx.getSource();
                        var entity = source.method_9228();

                        if (entity == null) {
                            ctx.getSource().method_9213(class_2561.method_43471("commands.map_utils.no_entity"));
                            return -1;
                        }

                        var pos = entity.method_33571();
                        var rotation = source.method_9210();
                        var path = PathArgumentType.getPath(ctx, "path");

                        if (path == null) {
                            ctx.getSource().method_9213(class_2561.method_43471("commands.map_utils.path.not_found"));
                            return -1;
                        }

                        var controlPoints = path.controlPoints();
                        var index = IntegerArgumentType.getInteger(ctx, "before");

                        if (index < 0 || index > controlPoints.size()) {
                            ctx.getSource().method_9213(class_2561.method_43471("commands.map_utils.path.edit.out_of_bounds"));
                            return -1;
                        }

                        controlPoints.add(index, new SplineControlPoint(pos, new class_241(rotation.field_1342, rotation.field_1343)));
                        MapUtils.invalidateData(source.method_9211());

                        ctx.getSource().method_9226(() -> class_2561.method_43471("commands.map_utils.path.edit.add.success"), false);

                        return 1;
                    }))).then(method_9247("remove").then(method_9244("index", IntegerArgumentType.integer(0)).executes(ctx -> {
                        var source = ctx.getSource();
                        var path = PathArgumentType.getPath(ctx, "path");

                        if (path == null) {
                            ctx.getSource().method_9213(class_2561.method_43471("commands.map_utils.path.not_found"));
                            return -1;
                        }

                        var controlPoints = path.controlPoints();
                        var index = IntegerArgumentType.getInteger(ctx, "index");

                        if (controlPoints.size() <= 1) {
                            ctx.getSource().method_9213(class_2561.method_43471("commands.map_utils.path.edit.remove.to_few_control_points"));
                            return -1;
                        }

                        if (index < 0 || index >= controlPoints.size()) {
                            ctx.getSource().method_9213(class_2561.method_43471("commands.map_utils.path.edit.out_of_bounds"));
                            return -1;
                        }

                        controlPoints.remove(index);
                        MapUtils.invalidateData(source.method_9211());

                        ctx.getSource().method_9226(() -> class_2561.method_43471("commands.map_utils.path.edit.remove.success"), false);

                        return 1;
                    }))))
                )
        );
    }

    public static void registerTickListener() {
        ServerTickEvents.START_SERVER_TICK.register((server) -> {
            for (int i = list.size() - 1; i >= 0; i--) {
                var data = list.get(i);
                var progress = ((float) data.pathTicks) / data.pathDuration;

                if (progress > 1 || data.entity == null) {
                    list.remove(i);
                } else {
                    data.pathTicks++;

                    var pos = data.path.getPosition(progress);
                    var rot = data.path.getRotation(progress);

                    data.entity.method_33574(pos);
                    data.entity.method_60608(rot.field_1343, rot.field_1342);
                }
            }
        });
    }
}
