package dev.doublekekse.map_utils.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.StringArgumentType;
import dev.doublekekse.map_utils.data.MapUtilsSavedData;
import java.util.ArrayList;
import net.minecraft.class_11352;
import net.minecraft.class_11362;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1321;
import net.minecraft.class_2168;
import net.minecraft.class_2186;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3730;
import net.minecraft.class_8942;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

public class PetsCommand {

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register(
            method_9247("pets").requires(source -> source.method_9259(2))
                .then(method_9247("store").then(method_9244("player", class_2186.method_9305()).then(method_9244("id", StringArgumentType.string()).executes(ctx -> {
                        var player = class_2186.method_9315(ctx, "player");
                        var id = player.method_5845() + "-" + StringArgumentType.getString(ctx, "id");

                        var level = player.method_51469();
                        var pets = level.method_8390(class_1321.class, player.method_5829().method_1014(20), (animal) -> animal.method_35057() == player);
                        var data = MapUtilsSavedData.getServerData(ctx.getSource().method_9211());

                        var list = new ArrayList<class_2487>(pets.size());

                        for (var pet : pets) {
                            var valueOutput = class_11362.method_71459(class_8942.field_60348, level.method_30349());

                            if (pet.method_5662(valueOutput)) {
                                list.add(valueOutput.method_71475());
                                pet.method_31472();
                            }
                        }

                        data.setPets(id, list);

                        ctx.getSource().method_9226(() -> class_2561.method_43469("commands.map_utils.pets.store", id), false);

                        return 1;
                    }
                )))).then(method_9247("load").then(method_9244("player", class_2186.method_9305()).then(method_9244("id", StringArgumentType.string()).executes(ctx -> {
                    var player = class_2186.method_9315(ctx, "player");
                    var id = player.method_5845() + "-" + StringArgumentType.getString(ctx, "id");

                    var data = MapUtilsSavedData.getServerData(ctx.getSource().method_9211());
                    var pets = data.getPets(id);

                    if (pets == null) {
                        ctx.getSource().method_9213(class_2561.method_43469("commands.map_utils.pets.missing", id));
                        return 0;
                    }

                    var level = player.method_51469();
                    for (var pet : pets) {
                        var valueInput = class_11352.method_71417(class_8942.field_60348, level.method_30349(), pet);
                        class_1299.method_17842(valueInput, level, class_3730.field_52444, (class_1297 entity) -> {
                            level.method_8649(entity);
                            return entity;
                        });
                    }

                    ctx.getSource().method_9226(() -> class_2561.method_43469("commands.map_utils.pets.load", id), false);

                    return 1;
                })))).then(method_9247("list").executes(ctx -> {
                    var source = ctx.getSource();
                    var data = MapUtilsSavedData.getServerData(source.method_9211());

                    source.method_9226(() -> class_2561.method_43471("commands.map_utils.pets.list"), false);

                    for (var key : data.pets.keySet()) {
                        source.method_9226(() -> class_2561.method_43470(key), false);
                    }

                    return 1;
                }))
        );
    }
}
