package dev.doublekekse.map_utils.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import dev.doublekekse.map_utils.block.VariableRedstoneBlock;
import dev.doublekekse.map_utils.timer.CommandCallback;
import dev.doublekekse.map_utils.timer.DeactivateBlockCallback;
import net.minecraft.class_2168;
import net.minecraft.class_2245;
import net.minecraft.class_2262;
import net.minecraft.class_2561;

import static dev.doublekekse.map_utils.registry.MapUtilsBlocks.VARIABLE_REDSTONE_BLOCK;
import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

public class RedstoneCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register(
            method_9247("redstone").requires(source -> source.method_9259(2))
                .then(method_9244("blockPos", class_2262.method_9698()).then(method_9244("power", IntegerArgumentType.integer(0, 15)).then(method_9244("time", class_2245.method_48287(1)).executes(context -> {
                    var source = context.getSource();
                    var level = source.method_9225();
                    var blockPos = class_2262.method_48299(context, "blockPos");
                    var timeOffset = IntegerArgumentType.getInteger(context, "time");
                    var gameTime = source.method_9225().method_8510() + timeOffset;
                    var timerQueue = source.method_9211().method_27728().method_27859().method_143();
                    var power = IntegerArgumentType.getInteger(context, "power");

                    if (!level.method_8320(blockPos).method_27852(VARIABLE_REDSTONE_BLOCK)) {
                        source.method_9213(class_2561.method_43469("commands.redstone.failed", blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260()));
                        return -1;
                    }

                    timerQueue.method_985("redstone callback", gameTime, new DeactivateBlockCallback(level.method_27983(), blockPos));

                    level.method_8501(blockPos, VARIABLE_REDSTONE_BLOCK.method_9564().method_11657(VariableRedstoneBlock.POWER, power));
                    source.method_9226(() -> class_2561.method_43469("commands.redstone.timed", blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260(), power, timeOffset), true);

                    return 1;
                })).executes((context -> {
                    var source = context.getSource();
                    var level = source.method_9225();
                    var blockPos = class_2262.method_48299(context, "blockPos");
                    var power = IntegerArgumentType.getInteger(context, "power");

                    if (!level.method_8320(blockPos).method_27852(VARIABLE_REDSTONE_BLOCK)) {
                        source.method_9213(class_2561.method_43469("commands.redstone.failed", blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260()));
                        return -1;
                    }

                    level.method_8501(blockPos, VARIABLE_REDSTONE_BLOCK.method_9564().method_11657(VariableRedstoneBlock.POWER, power));
                    source.method_9226(() -> class_2561.method_43469("commands.redstone.infinite", blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260(), power), true);
                    return 1;
                }
                ))))
        );
    }
}
