package dev.doublekekse.map_utils.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import dev.doublekekse.map_utils.duck.CommandSourceStackDuck;
import dev.doublekekse.map_utils.timer.CommandCallback;
import net.minecraft.class_2168;
import net.minecraft.class_2245;
import net.minecraft.class_2561;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

public class ScheduleCommandExtension {

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register(
            method_9247("schedule").then(method_9247("command").then(method_9244("time", class_2245.method_9489()).then(method_9244("command", StringArgumentType.greedyString()).executes(context -> {
                var source = context.getSource();
                var entity = source.method_9228();
                var level = source.method_9225();
                var timeOffset = IntegerArgumentType.getInteger(context, "time");
                var worldTime = source.method_9225().method_8510() + timeOffset;
                var command = StringArgumentType.getString(context, "command");
                var timerQueue = source.method_9211().method_27728().method_27859().method_143();

                timerQueue.method_985(command, worldTime, new CommandCallback(level.method_27983(), entity == null ? null : entity.method_5667(), command, source.method_9222(), source.method_9210(), ((CommandSourceStackDuck) source).mapUtils$permissionLevel()));

                source.method_9226(() -> class_2561.method_43469("commands.map_utils.schedule.created.command", command, timeOffset, worldTime), true);
                return 1;
            }))))
        );
    }
}
