package dev.doublekekse.map_utils.command.argument;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.doublekekse.map_utils.client.MapUtilsClient;
import dev.doublekekse.map_utils.curve.SplinePath;
import dev.doublekekse.map_utils.data.MapUtilsSavedData;
import org.jetbrains.annotations.Nullable;

import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_637;

public class PathArgumentType implements ArgumentType<String> {
    @Override
    public String parse(StringReader reader) throws CommandSyntaxException {
        return reader.readString();
    }

    public static @Nullable String getPathId(final CommandContext<class_2168> context, final String name) {
        return context.getArgument(name, String.class);
    }

    public static @Nullable SplinePath getPath(final CommandContext<class_2168> context, final String name) {
        var id = context.getArgument(name, String.class);
        var server = context.getSource().method_9211();
        var savedData = MapUtilsSavedData.getServerData(server);

        return savedData.paths.get(id);
    }

    @Override
    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        if (context.getSource() instanceof class_637) {
            var savedData = MapUtilsClient.clientSavedData;

            return class_2172.method_9265(savedData.paths.keySet(), builder);
        }

        return Suggestions.empty();
    }

    public static PathArgumentType path() {
        return new PathArgumentType();
    }
}
