package dev.doublekekse.map_utils.data;

import com.mojang.serialization.Codec;
import dev.doublekekse.map_utils.MapUtils;
import dev.doublekekse.map_utils.curve.SplinePath;
import net.minecraft.class_10741;
import net.minecraft.class_11343;
import net.minecraft.class_11352;
import net.minecraft.class_11362;
import net.minecraft.class_1657;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_26;
import net.minecraft.class_8942;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.storage.*;
import org.jetbrains.annotations.NotNull;

import java.util.*;

// TODO: Abstract mod compat into single class modules. Sorta like what Switchy's got going on.
public class MapUtilsSavedData extends class_18 {
    public class_2487 inventories = new class_2487();
    public Map<String, List<class_2487>> pets = new HashMap<>();
    public Map<String, SplinePath> paths = new HashMap<>();

    public static final Codec<MapUtilsSavedData> CODEC = class_2487.field_25128.xmap(
        MapUtilsSavedData::load,
        MapUtilsSavedData::save
    );

    public void setPets(String id, List<class_2487> pets) {
        this.pets.put(id, pets);
    }

    public List<class_2487> getPets(String id) {
        return this.pets.get(id);
    }

    public void saveInventories(class_1657 player, String id, boolean remove) {
        var inventory = class_11362.method_71459(class_8942.field_60348, player.method_37908().method_30349());
        player.method_31548().method_7384(inventory.method_71467("minecraft:inventory", class_11343.field_60354));

        if (remove) {
            player.method_31548().method_5448();
        }

        inventories.method_10566(id, inventory.method_71475());
        method_80();
    }

    @SuppressWarnings("UnstableApiUsage")
    public boolean loadInventories(class_1657 player, String id, boolean remove) {
        var inventory = class_11352.method_71417(class_8942.field_60348, player.method_37908().method_30349(), inventories.method_10580(id).method_68571().get());
        if (inventory == null) {
            return false;
        }

        player.method_31548().method_7397(inventory.method_71435("minecraft:inventory", class_11343.field_60354).get());

        if (remove) {
            inventories.method_10551(id);
            method_80();
        }

        return true;
    }

    public @NotNull class_2487 save() {
        var tag = new class_2487();

        tag.method_10566("inventories", inventories);
        tag.method_10566("paths", savePaths());
        tag.method_10566("pets", savePets());

        return tag;
    }


    private class_2487 savePets() {
        var tag = new class_2487();

        for (var entry : pets.entrySet()) {
            var listTag = new class_2499();
            listTag.addAll(entry.getValue());
            tag.method_10566(entry.getKey(), listTag);
        }

        return tag;
    }

    @SuppressWarnings("unchecked")
    private void loadPets(class_2487 tag) {
        for (var entry : tag.method_59874()) {
            var listTag = entry.getValue().method_68592().get();
            var list = new ArrayList<>(listTag);

            pets.put(entry.getKey(), (List<class_2487>) (Object) list);
        }
    }

    public class_2487 savePaths() {
        var tag = new class_2487();

        for (var entry : paths.entrySet()) {
            tag.method_10566(entry.getKey(), entry.getValue().write());
        }

        return tag;
    }

    public void loadPaths(class_2487 pathsTag) {
        for (var entry : pathsTag.method_59874()) {
            var list = entry.getValue().method_68592().get();
            paths.put(entry.getKey(), SplinePath.read(list));
        }
    }

    public static MapUtilsSavedData load(class_2487 compoundTag) {
        var data = new MapUtilsSavedData();

        data.inventories = compoundTag.method_10562("inventories").get();
        data.loadPaths(compoundTag.method_10562("paths").get());
        data.loadPets(compoundTag.method_10562("pets").get());

        return data;
    }

    public static MapUtilsSavedData getServerData(MinecraftServer server) {
        class_26 persistentStateManager = server.method_30002().method_17983();
        MapUtilsSavedData data = persistentStateManager.method_17924(TYPE);
        data.method_80();

        return data;
    }

    private static final class_10741<MapUtilsSavedData> TYPE = new class_10741<>(MapUtils.MOD_ID, MapUtilsSavedData::new,
        MapUtilsSavedData.CODEC,
        null);
}
