package dev.doublekekse.map_utils.gizmo;

import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_4587;
import net.minecraft.class_863;
import org.joml.Vector3f;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class Gizmo {
    public class_243 position;

    public Consumer<class_243> onPositionChange;
    public Supplier<class_243> getPosition;

    public static Gizmo bind(Supplier<class_243> getPosition, Consumer<class_243> onChange) {
        var gizmo = new Gizmo();

        gizmo.getPosition = getPosition;
        gizmo.onPositionChange = onChange;

        gizmo.position = getPosition.get();

        return gizmo;
    }

    public void scroll(class_2350 direction, double value) {
        var offset = direction.method_62676().method_1021(.1 * value);
        move(offset);
    }

    public void move(class_243 offset) {
        position = position.method_1019(offset);
        onPositionChange.accept(position);
    }

    void drawLine(WorldRenderContext ctx, class_4587.class_4665 pose, Vector3f offset, int color) {
        var normal = ctx.camera().method_19335().mul(-1);
        var lineConsumer = ctx.consumers().getBuffer(class_1921.field_21695);

        var fPos = position.method_46409();

        lineConsumer.method_61032(pose, fPos).method_39415(color).method_60831(pose, normal.x, normal.y, normal.z);
        lineConsumer.method_61032(pose, fPos.add(offset)).method_39415(color).method_60831(pose, normal.x, normal.y, normal.z);
    }

    public class_238 getAABB() {
        var radius = .1;
        return new class_238(position.field_1352 - radius, position.field_1351 - radius, position.field_1350 - radius, position.field_1352 + radius, position.field_1351 + radius, position.field_1350 + radius);
    }

    public Collection<GizmoAxis> getAxes() {
        var list = new ArrayList<GizmoAxis>(3);

        list.add(new GizmoAxis(this, new class_243(1, 0, 0), 0xffff0000));
        list.add(new GizmoAxis(this, new class_243(0, 1, 0), 0xff00ff00));
        list.add(new GizmoAxis(this, new class_243(0, 0, 1), 0xff0000ff));

        return list;
    }

    public Optional<GizmoTransformation> transformation(class_243 pos, class_243 end) {
        return getAABB().method_992(pos, end).map(intersection -> GizmoTransformation.of(this, null, intersection, pos));
    }

    public void render(WorldRenderContext ctx, boolean isActive) {
        var poseStack = ctx.matrixStack();
        var pose = poseStack.method_23760();
        var aabb = getAABB();

        class_863.method_23102(poseStack, ctx.consumers(), aabb, 1, isActive ? 0 : 1, 1, 1);

        if (!isActive) {
            return;
        }

        for (var axis : getAxes()) {
            drawLine(ctx, pose, axis.dir().method_46409(), axis.color());
        }
    }
}
