package dev.doublekekse.map_utils.gizmo;

import net.minecraft.class_1657;
import net.minecraft.class_243;
import org.jetbrains.annotations.Nullable;

public record GizmoTransformation(
    Gizmo gizmo,
    @Nullable GizmoAxis axis,
    class_243 startingPos,
    class_243 startingInteractionPos,
    double startingDist
) {
    public static GizmoTransformation of(Gizmo gizmo, @Nullable GizmoAxis axis, class_243 intersectionPos, class_243 eyePosition) {
        return new GizmoTransformation(gizmo, axis, gizmo.position, intersectionPos.method_1020(gizmo.position), intersectionPos.method_1022(eyePosition));
    }

    public void apply(class_1657 player) {
        var pos = player.method_33571();
        var target = pos.method_1019(player.method_5720().method_1021(startingDist));
        var offset = target.method_1020(gizmo.position).method_1020(startingInteractionPos);

        if (axis != null) {
            offset = offset.method_18806(axis.dir());
        }

        gizmo.move(offset);
    }
}
