package dev.doublekekse.map_utils.mixin;

import dev.doublekekse.map_utils.curve.SplinePath;
import dev.doublekekse.map_utils.state.CameraOverrideState;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_4184;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_4184.class)
public abstract class CameraMixin {
    @Shadow
    private boolean detached;

    @Shadow
    protected abstract void setPosition(class_243 vec3);

    @Shadow
    protected abstract void setRotation(float f, float g);

    @Shadow
    private class_243 position;

    @Shadow
    public abstract float getXRot();

    @Shadow
    public abstract float getYRot();

    @Unique
    class_243 oldCameraPosition;
    @Unique
    class_241 oldCameraRotation;
    @Unique
    float lastTimeSinceLastTick;


    @Unique
    private static class_243 overridePosition;
    @Unique
    private static class_241 overrideRotation;

    @Inject(method = "setup", at = @At("TAIL"))
    void setup(class_1922 blockGetter, class_1297 entity, boolean bl, boolean bl2, float timeSinceLastTick, CallbackInfo ci) {
        lastTimeSinceLastTick = timeSinceLastTick;

        tickPath(timeSinceLastTick);
        tickPosition(timeSinceLastTick);
        tickRotation(timeSinceLastTick);
    }

    @Unique
    void tickRotation(float timeSinceLastTick) {
        if (overrideRotation == null) {
            return;
        }

        this.setRotation(overrideRotation.field_1343, overrideRotation.field_1342);

        if (CameraOverrideState.interpolateRotation) {
            var newRotation = SplinePath.lerpRotation(oldCameraRotation, overrideRotation, timeSinceLastTick);
            setRotation(newRotation.field_1343, newRotation.field_1342);
        } else {
            setRotation(overrideRotation.field_1343, overrideRotation.field_1342);
        }
    }

    @Unique
    void tickPosition(float timeSinceLastTick) {
        if (overridePosition == null) {
            return;
        }

        detached = true;

        if (CameraOverrideState.interpolatePosition) {
            var newPosition = oldCameraPosition.method_35590(overridePosition, timeSinceLastTick);
            setPosition(newPosition);
        } else {
            setPosition(overridePosition);
        }
    }

    @Unique
    void tickPath(float timeSinceLastTick) {
        if (!isFollowingPath()) {
            return;
        }

        var progress = (CameraOverrideState.splineTicks + timeSinceLastTick) / CameraOverrideState.splineDuration;

        if (progress > 1) {
            stopPath();
            return;
        }

        overridePosition = CameraOverrideState.spline.getPosition(progress);
        overrideRotation = CameraOverrideState.spline.getRotation(progress);
    }

    @Unique
    void stopPath() {
        CameraOverrideState.spline = null;
        CameraOverrideState.splineDuration = 1;

        CameraOverrideState.fov = -1;
    }

    @Unique
    boolean isFollowingPath() {
        return CameraOverrideState.spline != null;
    }

    @Inject(method = "tick", at = @At("HEAD"))
    void tick(CallbackInfo ci) {
        lastTimeSinceLastTick = 0;

        oldCameraPosition = overridePosition;
        oldCameraRotation = overrideRotation;

        overridePosition = CameraOverrideState.position;
        overrideRotation = CameraOverrideState.rotation;

        if (oldCameraPosition == null) {
            oldCameraPosition = position;
        }

        if (oldCameraRotation == null) {
            oldCameraRotation = new class_241(getXRot(), getYRot());
        }

        CameraOverrideState.splineTicks++;
    }
}
