package dev.doublekekse.map_utils.mixin;

import dev.doublekekse.map_utils.state.CameraOverrideState;
import net.minecraft.class_2960;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_9779;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_329.class)
public abstract class GuiMixin {
    @Shadow
    protected abstract void renderTextureOverlay(class_332 guiGraphics, class_2960 resourceLocation, float f);

    @Shadow
    protected abstract void renderSpyglassOverlay(class_332 guiGraphics, float f);

    @Inject(method = "renderCameraOverlays", at = @At("HEAD"))
    void render(class_332 guiGraphics, class_9779 deltaTracker, CallbackInfo ci) {
        if (CameraOverrideState.overlayLocation == null) {
            return;
        }

        if (CameraOverrideState.overlayLocation.method_12832().equals("textures/misc/spyglass_scope.png")) {
            renderSpyglassOverlay(guiGraphics, CameraOverrideState.overlayOpacity);
            return;
        }

        renderTextureOverlay(guiGraphics, CameraOverrideState.overlayLocation, CameraOverrideState.overlayOpacity);
    }
}
