package dev.doublekekse.map_utils.mixin;

import dev.doublekekse.map_utils.client.MapUtilsClient;
import dev.doublekekse.map_utils.gizmo.Gizmo;
import dev.doublekekse.map_utils.gizmo.Gizmos;
import dev.doublekekse.map_utils.state.CameraOverrideState;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_4093;
import net.minecraft.class_437;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_310.class)
public abstract class MinecraftMixin
    extends class_4093<Runnable> {
    @Shadow
    @Nullable
    public class_746 player;

    @Shadow
    @Final
    public class_315 options;

    @Shadow
    private int rightClickDelay;

    public MinecraftMixin(String string) {
        super(string);
    }

    @Inject(method = "disconnect", at = @At("HEAD"))
    void disconnect(CallbackInfo ci) {
        CameraOverrideState.reset();
    }

    @Inject(method = "clearClientLevel", at = @At("HEAD"))
    void clearClientLevel(class_437 screen, CallbackInfo ci) {
        CameraOverrideState.reset();
    }

    @Inject(method = "handleKeybinds", at = @At("HEAD"))
    void handleKeybinds(CallbackInfo ci) {
        if (!options.field_1904.method_1434()) {
            Gizmos.transformation = null;
        }
    }

    @Inject(method = "startUseItem", at = @At("HEAD"), cancellable = true)
    void startUseItem(CallbackInfo ci) {
        assert player != null;

        if (!MapUtilsClient.pathEditorEnabled) {
            return;
        }

        var pos = player.method_33571();
        var end = pos.method_1019(player.method_5720().method_1021(3));

        if (Gizmos.transformation != null) {
            Gizmos.transformation.apply(player);
            ci.cancel();
            return;
        }

        if (Gizmos.selectedGizmo != null) {
            var gizmo = Gizmos.selectedGizmo;
            var gizmoTransformation = gizmo.transformation(pos, end);

            if (gizmoTransformation.isPresent()) {
                Gizmos.transformation = gizmoTransformation.get();
                ci.cancel();
                return;
            }

            var axes = gizmo.getAxes();

            for (var axis : axes) {
                var axisTransformation = axis.transformation(pos, end);
                if (axisTransformation.isPresent()) {
                    Gizmos.transformation = axisTransformation.get();
                    ci.cancel();
                    return;
                }
            }
        }

        class_243 closest = null;
        Gizmo closestGizmo = null;
        Gizmos.selectedGizmo = null;
        Gizmos.transformation = null;

        for (var gizmo : Gizmos.gizmos) {
            var intersection = gizmo.getAABB().method_992(pos, end);
            if (intersection.isPresent()) {
                if (closest == null || intersection.get().method_1027() < closest.method_1027()) {
                    closest = intersection.get();
                    closestGizmo = gizmo;
                }
            }
        }

        if (closestGizmo == null) {
            return;
        }

        Gizmos.selectedGizmo = closestGizmo;
        rightClickDelay = 3;
        ci.cancel();

    }
}
