package dev.doublekekse.map_utils.mixin;

import dev.doublekekse.map_utils.gizmo.Gizmos;
import net.minecraft.class_310;
import net.minecraft.class_312;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_312.class)
public class MouseHandlerMixin {
    @Shadow
    @Final
    private class_310 minecraft;

    @Inject(method = "onScroll", at = @At("HEAD"), cancellable = true)
    void onScroll(long l, double d, double e, CallbackInfo ci) {
        double sensitivity = minecraft.field_1690.method_41806().method_41753();
        boolean discreteMouseScroll = this.minecraft.field_1690.method_42439().method_41753();
        double scroll = (discreteMouseScroll ? Math.signum(e) : e) * sensitivity;

        if(Gizmos.selectedGizmo != null) {
            ci.cancel();

            var direction = class_310.method_1551().field_1724.method_58149();
            Gizmos.selectedGizmo.scroll(direction, scroll);
        }
    }
}
