package dev.doublekekse.map_utils.packet;

import dev.doublekekse.map_utils.MapUtils;
import net.minecraft.class_2540;
import net.minecraft.class_8710;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record CameraSplinePacket(@Nullable String path, int splineDuration) implements class_8710 {
    public static final class_9139<class_2540, CameraSplinePacket> STREAM_CODEC = class_8710.method_56484(CameraSplinePacket::write, CameraSplinePacket::load);
    public static final class_8710.class_9154<CameraSplinePacket> TYPE = new class_8710.class_9154<>(MapUtils.id("camera_spline_packet"));

    static CameraSplinePacket load(class_2540 buf) {
        var length = buf.readInt();

        if (length == -1) {
            return new CameraSplinePacket(null, 1);
        }

        var path = buf.method_19772();

        return new CameraSplinePacket(path, buf.readInt());
    }

    @Override
    public @NotNull class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }

    public void write(class_2540 buf) {
        if (path == null) {
            buf.method_53002(-1);
            return;
        }

        buf.method_53002(1);
        buf.method_10814(path);
        buf.method_53002(splineDuration);
    }
}
