package dev.doublekekse.map_utils.packet;

import dev.doublekekse.map_utils.MapUtils;
import dev.doublekekse.map_utils.client.MapUtilsClient;
import dev.doublekekse.map_utils.data.MapUtilsSavedData;
import dev.doublekekse.map_utils.gizmo.Gizmos;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

import java.util.Objects;

public record ClientboundSyncDataPacket(MapUtilsSavedData savedData) implements class_8710 {
    public static final class_9139<class_9129, ClientboundSyncDataPacket> STREAM_CODEC = class_8710.method_56484(ClientboundSyncDataPacket::write, ClientboundSyncDataPacket::load);
    public static final class_8710.class_9154<ClientboundSyncDataPacket> TYPE = new class_8710.class_9154<>(MapUtils.id("clientbound_sync_data"));

    private static ClientboundSyncDataPacket load(class_2540 buf) {
        var savedData = new MapUtilsSavedData();
        savedData.loadPaths(Objects.requireNonNull(buf.method_10798()));

        return new ClientboundSyncDataPacket(savedData);
    }

    @Override
    public @NotNull class_8710.class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }

    public void write(class_2540 buf) {
        buf.method_10794(savedData.savePaths());
    }

    public static void handle(ClientboundSyncDataPacket packet, ClientPlayNetworking.Context context) {
        MapUtilsClient.clientSavedData = packet.savedData;
        Gizmos.update();
    }
}
