package dev.doublekekse.map_utils.packet;

import dev.doublekekse.map_utils.MapUtils;
import dev.doublekekse.map_utils.curve.SplinePath;
import dev.doublekekse.map_utils.data.MapUtilsSavedData;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_8710;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record SavePathPacket(String id, SplinePath path) implements class_8710 {
    public static final class_9139<class_2540, SavePathPacket> STREAM_CODEC = class_9139.method_56435(
        class_9135.field_48554, SavePathPacket::id,
        SplinePath.STREAM_CODEC, SavePathPacket::path,
        SavePathPacket::new
    );
    public static final class_8710.class_9154<SavePathPacket> TYPE = new class_8710.class_9154<>(MapUtils.id("save_path"));

    @Override
    public class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }

    public void handle(ServerPlayNetworking.Context context) {
        var savedData = MapUtilsSavedData.getServerData(context.server());
        savedData.paths.put(id, path);

        context.player().method_64398(class_2561.method_43470("TEST"));
        MapUtils.syncData(context.responseSender(), context.server());
    }
}
