package dev.doublekekse.map_utils.packet;

import dev.doublekekse.map_utils.MapUtils;
import dev.doublekekse.map_utils.block.timer.TimerBlockEntity;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

public record SetTimerBlockPacket(
    class_2338 blockPos,
    int duration,
    int interval,
    boolean tickUnloaded
) implements class_8710 {
    public static final class_9139<class_9129, SetTimerBlockPacket> STREAM_CODEC = class_9139.method_56905(
        class_2338.field_48404, SetTimerBlockPacket::blockPos,
        class_9135.field_48550, SetTimerBlockPacket::duration,
        class_9135.field_48550, SetTimerBlockPacket::interval,
        class_9135.field_48547, SetTimerBlockPacket::tickUnloaded,
        SetTimerBlockPacket::new
    );
    public static final class_8710.class_9154<SetTimerBlockPacket> TYPE = new class_8710.class_9154<>(MapUtils.id("set_timer_block_packet"));

    @Override
    public @NotNull class_8710.class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }

    public void handle(ServerPlayNetworking.Context context) {
        var player = context.player();

        if (player.method_7338()) {
            class_2680 blockState = player.method_51469().method_8320(blockPos);

            if (player.method_51469().method_8321(blockPos) instanceof TimerBlockEntity timerBlockEntity) {
                timerBlockEntity.duration = duration;
                timerBlockEntity.interval = interval;
                timerBlockEntity.tickUnloaded = tickUnloaded;

                timerBlockEntity.method_5431();
                player.method_51469().method_8413(blockPos, blockState, blockState, 3);
            }
        }
    }
}
