package dev.doublekekse.map_utils.registry;

import dev.doublekekse.map_utils.MapUtils;
import dev.doublekekse.map_utils.block.VariableRedstoneBlock;
import dev.doublekekse.map_utils.block.timer.TimerBlock;
import java.util.function.Function;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2498;
import net.minecraft.class_3620;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class MapUtilsBlocks {
    public static final VariableRedstoneBlock VARIABLE_REDSTONE_BLOCK = register(
        VariableRedstoneBlock::new, class_4970.class_2251.method_9637()
            .method_31710(class_3620.field_16002)
            .method_29292()
            .method_9629(5.0F, 6.0F)
            .method_9626(class_2498.field_11533)
            .method_26236(class_2246::method_26122)
        , "variable_redstone_block", true);

    public static final TimerBlock TIMER_BLOCK = register(TimerBlock::new,
        class_4970.class_2251.method_9637()
            .method_9626(class_2498.field_47085)
        , "timer_block",
        true
    );

    private static <T extends class_2248> T register(Function<class_4970.class_2251, T> blockFactory, class_4970.class_2251 properties, String path, boolean shouldRegisterItem) {
        var blockKey = class_5321.method_29179(class_7924.field_41254, MapUtils.id(path));
        var block = blockFactory.apply(properties.method_63500(blockKey));

        if (shouldRegisterItem) {
            var itemKey = class_5321.method_29179(class_7924.field_41197, MapUtils.id(path));

            var blockItem = new class_1747(block, new class_1792.class_1793().method_63685().method_63686(itemKey));
            class_2378.method_39197(class_7923.field_41178, itemKey, blockItem);
        }

        return class_2378.method_39197(class_7923.field_41175, blockKey, block);
    }

    public static void register() {
    }
}
