package dev.doublekekse.map_utils.timer;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.doublekekse.map_utils.compat.player_roles.PlayerRoleCompatibility;
import dev.doublekekse.map_utils.utils.AdditionalCodecs;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2165;
import net.minecraft.class_2168;
import net.minecraft.class_234;
import net.minecraft.class_236;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.UUID;

public record CommandCallback(class_5321<class_1937> dimension, @Nullable UUID entityUUID,
                              String command, class_243 position, class_241 rotation,
                              int permissionLevel)
    implements class_234<MinecraftServer> {
    public static final MapCodec<CommandCallback> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(
            class_5321.method_39154(class_7924.field_41223).fieldOf("dimension").forGetter(CommandCallback::dimension),
            AdditionalCodecs.UUID_CODEC.optionalFieldOf("entity_uuid", null).forGetter(CommandCallback::entityUUID),
            Codec.STRING.fieldOf("command").forGetter(CommandCallback::command),
            class_243.field_38277.fieldOf("position").forGetter(CommandCallback::position),
            class_241.field_56695.fieldOf("rotation").forGetter(CommandCallback::rotation),
            Codec.INT.fieldOf("permission_level").forGetter(CommandCallback::permissionLevel)
        ).apply(instance, CommandCallback::new)
    );

    @Override
    public void handle(MinecraftServer minecraftServer, class_236<MinecraftServer> timerQueue, long l) {
        var level = minecraftServer.method_3847(dimension);
        if (level == null) {
            // TODO
            return;
        }
        var entity = entityUUID == null ? null : level.method_66347(entityUUID);
        minecraftServer.method_3734().method_44252(createCommandSourceStack(entity, level), command);
    }

    private class_2168 createCommandSourceStack(@Nullable class_1297 entity, class_3218 level) {
        String name = entity == null ? "CommandCallback" : entity.method_5477().getString() + " (CommandCallback)";
        class_2561 nameComponent = class_2561.method_43470(name);

        entityNameComponent:
        if (entity != null) {
            var displayName = entity.method_5476();
            displayName.method_27661().method_27693(" (CommandCallback)");
        }

        // TODO
        var stack = new class_2168(class_2165.field_17395, position, rotation, level, permissionLevel, name, nameComponent, level.method_8503(), entity);

        if (FabricLoader.getInstance().isModLoaded("player_roles")) {
            PlayerRoleCompatibility.applyCommandIdentityType(stack);
        }

        return stack;
    }

    @Override
    public @NotNull MapCodec<CommandCallback> method_67704() {
        return CODEC;
    }
}
