/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.api.configuration;

import fr.maxlego08.essentials.api.configuration.ReplacePlaceholderElement;
import fr.maxlego08.essentials.api.configuration.placeholders.NumberPlaceholder;
import fr.maxlego08.essentials.api.configuration.placeholders.StringPlaceholder;
import java.util.List;

public record ReplacePlaceholder(String placeholder, String defaultValue, List<ReplacePlaceholderElement> elements) {
    public String replace(String result) {
        for (ReplacePlaceholderElement element : this.elements) {
            StringPlaceholder stringPlaceholder;
            if (element instanceof NumberPlaceholder) {
                NumberPlaceholder numberPlaceholder = (NumberPlaceholder)element;
                try {
                    long longResult = Long.parseLong(result);
                    if (longResult > numberPlaceholder.maxValue()) continue;
                    return numberPlaceholder.result().replace("%result%", result);
                }
                catch (NumberFormatException ignored) {
                    return result + " is not a number !";
                }
            }
            if (!(element instanceof StringPlaceholder) || !result.equalsIgnoreCase((stringPlaceholder = (StringPlaceholder)element).equalsTo())) continue;
            return stringPlaceholder.result().replace("%result%", result);
        }
        return this.defaultValue.replace("%result%", result);
    }
}

