/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.api.discord;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.HttpsURLConnection;

public class DiscordWebhook {
    private final String url;
    private final List<EmbedObject> embeds = new ArrayList<EmbedObject>();
    private String content;
    private String username;
    private String avatarUrl;
    private boolean tts;

    public DiscordWebhook(String url) {
        this.url = url;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setAvatarUrl(String avatarUrl) {
        this.avatarUrl = avatarUrl;
    }

    public void setTts(boolean tts) {
        this.tts = tts;
    }

    public void addEmbed(EmbedObject embed) {
        this.embeds.add(embed);
    }

    public void execute() throws IOException {
        if (this.content == null && this.embeds.isEmpty()) {
            throw new IllegalArgumentException("Set content or add at least one EmbedObject");
        }
        JsonObject json = new JsonObject();
        if (this.content != null) {
            json.addProperty("content", this.content);
        }
        if (this.username != null) {
            json.addProperty("username", this.username);
        }
        if (this.avatarUrl != null) {
            json.addProperty("avatar_url", this.avatarUrl);
        }
        json.addProperty("tts", Boolean.valueOf(this.tts));
        if (!this.embeds.isEmpty()) {
            JsonArray embedArray = new JsonArray();
            for (EmbedObject embed : this.embeds) {
                List<EmbedObject.Field> fields;
                EmbedObject.Author author;
                EmbedObject.Thumbnail thumbnail;
                EmbedObject.Image image;
                EmbedObject.Footer footer;
                JsonObject jsonEmbed = new JsonObject();
                if (embed.getTitle() != null) {
                    jsonEmbed.addProperty("title", embed.getTitle());
                }
                if (embed.getDescription() != null) {
                    jsonEmbed.addProperty("description", embed.getDescription());
                }
                if (embed.getUrl() != null) {
                    jsonEmbed.addProperty("url", embed.getUrl());
                }
                if (embed.getColor() != null) {
                    Color color = embed.getColor();
                    int rgb = (color.getRed() << 16) + (color.getGreen() << 8) + color.getBlue();
                    jsonEmbed.addProperty("color", (Number)rgb);
                }
                if ((footer = embed.getFooter()) != null && (footer.getText() != null || footer.getIconUrl() != null)) {
                    JsonObject jsonFooter = new JsonObject();
                    if (footer.getText() != null) {
                        jsonFooter.addProperty("text", footer.getText());
                    }
                    if (footer.getIconUrl() != null) {
                        jsonFooter.addProperty("icon_url", footer.getIconUrl());
                    }
                    jsonEmbed.add("footer", (JsonElement)jsonFooter);
                }
                if ((image = embed.getImage()) != null && image.getUrl() != null) {
                    JsonObject jsonImage = new JsonObject();
                    jsonImage.addProperty("url", image.getUrl());
                    jsonEmbed.add("image", (JsonElement)jsonImage);
                }
                if ((thumbnail = embed.getThumbnail()) != null && thumbnail.getUrl() != null) {
                    JsonObject jsonThumbnail = new JsonObject();
                    jsonThumbnail.addProperty("url", thumbnail.getUrl());
                    jsonEmbed.add("thumbnail", (JsonElement)jsonThumbnail);
                }
                if ((author = embed.getAuthor()) != null && (author.getName() != null || author.getUrl() != null || author.getIconUrl() != null)) {
                    JsonObject jsonAuthor = new JsonObject();
                    if (author.getName() != null) {
                        jsonAuthor.addProperty("name", author.getName());
                    }
                    if (author.getUrl() != null) {
                        jsonAuthor.addProperty("url", author.getUrl());
                    }
                    if (author.getIconUrl() != null) {
                        jsonAuthor.addProperty("icon_url", author.getIconUrl());
                    }
                    jsonEmbed.add("author", (JsonElement)jsonAuthor);
                }
                if ((fields = embed.getFields()) != null && !fields.isEmpty()) {
                    JsonArray jsonFields = new JsonArray();
                    for (EmbedObject.Field field : fields) {
                        if (field.getName() == null || field.getValue() == null) continue;
                        JsonObject jsonField = new JsonObject();
                        jsonField.addProperty("name", field.getName());
                        jsonField.addProperty("value", field.getValue());
                        jsonField.addProperty("inline", Boolean.valueOf(field.isInline()));
                        jsonFields.add((JsonElement)jsonField);
                    }
                    if (!jsonFields.isEmpty()) {
                        jsonEmbed.add("fields", (JsonElement)jsonFields);
                    }
                }
                embedArray.add((JsonElement)jsonEmbed);
            }
            json.add("embeds", (JsonElement)embedArray);
        }
        URL url = URI.create(this.url).toURL();
        HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
        connection.addRequestProperty("Content-Type", "application/json");
        connection.addRequestProperty("User-Agent", "Java-DiscordWebhook-BY-Gelox_");
        connection.setDoOutput(true);
        connection.setRequestMethod("POST");
        OutputStream stream = connection.getOutputStream();
        String jsonString = new Gson().toJson((JsonElement)json);
        stream.write(jsonString.getBytes(StandardCharsets.UTF_8));
        stream.flush();
        stream.close();
        connection.getInputStream().close();
        connection.disconnect();
    }

    public static class EmbedObject {
        private final List<Field> fields = new ArrayList<Field>();
        private String title;
        private String description;
        private String url;
        private Color color;
        private Footer footer;
        private Thumbnail thumbnail;
        private Image image;
        private Author author;

        public String getTitle() {
            return this.title;
        }

        public EmbedObject setTitle(String title) {
            this.title = title;
            return this;
        }

        public String getDescription() {
            return this.description;
        }

        public EmbedObject setDescription(String description) {
            this.description = description;
            return this;
        }

        public String getUrl() {
            return this.url;
        }

        public EmbedObject setUrl(String url) {
            this.url = url;
            return this;
        }

        public Color getColor() {
            return this.color;
        }

        public EmbedObject setColor(Color color) {
            this.color = color;
            return this;
        }

        public Footer getFooter() {
            return this.footer;
        }

        public Thumbnail getThumbnail() {
            return this.thumbnail;
        }

        public EmbedObject setThumbnail(String url) {
            this.thumbnail = new Thumbnail(this, url);
            return this;
        }

        public Image getImage() {
            return this.image;
        }

        public EmbedObject setImage(String url) {
            this.image = new Image(this, url);
            return this;
        }

        public Author getAuthor() {
            return this.author;
        }

        public List<Field> getFields() {
            return this.fields;
        }

        public EmbedObject setFooter(String text, String icon) {
            this.footer = new Footer(this, text, icon);
            return this;
        }

        public EmbedObject setAuthor(String name, String url, String icon) {
            this.author = new Author(this, name, url, icon);
            return this;
        }

        public EmbedObject addField(String name, String value, boolean inline) {
            this.fields.add(new Field(this, name, value, inline));
            return this;
        }

        private class Footer {
            private final String text;
            private final String iconUrl;

            private Footer(EmbedObject embedObject, String text, String iconUrl) {
                this.text = text;
                this.iconUrl = iconUrl;
            }

            private String getText() {
                return this.text;
            }

            private String getIconUrl() {
                return this.iconUrl;
            }
        }

        private class Thumbnail {
            private final String url;

            private Thumbnail(EmbedObject embedObject, String url) {
                this.url = url;
            }

            private String getUrl() {
                return this.url;
            }
        }

        private class Image {
            private final String url;

            private Image(EmbedObject embedObject, String url) {
                this.url = url;
            }

            private String getUrl() {
                return this.url;
            }
        }

        private class Author {
            private final String name;
            private final String url;
            private final String iconUrl;

            private Author(EmbedObject embedObject, String name, String url, String iconUrl) {
                this.name = name;
                this.url = url;
                this.iconUrl = iconUrl;
            }

            private String getName() {
                return this.name;
            }

            private String getUrl() {
                return this.url;
            }

            private String getIconUrl() {
                return this.iconUrl;
            }
        }

        private class Field {
            private final String name;
            private final String value;
            private final boolean inline;

            private Field(EmbedObject embedObject, String name, String value, boolean inline) {
                this.name = name;
                this.value = value;
                this.inline = inline;
            }

            private String getName() {
                return this.name;
            }

            private String getValue() {
                return this.value;
            }

            private boolean isInline() {
                return this.inline;
            }
        }
    }
}

