/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.api.storage;

import fr.maxlego08.essentials.api.discord.DiscordAction;
import fr.maxlego08.essentials.api.dto.ChatMessageDTO;
import fr.maxlego08.essentials.api.dto.CooldownDTO;
import fr.maxlego08.essentials.api.dto.DiscordAccountDTO;
import fr.maxlego08.essentials.api.dto.DiscordCodeDTO;
import fr.maxlego08.essentials.api.dto.EconomyDTO;
import fr.maxlego08.essentials.api.dto.EconomyTransactionDTO;
import fr.maxlego08.essentials.api.dto.MailBoxDTO;
import fr.maxlego08.essentials.api.dto.PlayerSlotDTO;
import fr.maxlego08.essentials.api.dto.SanctionDTO;
import fr.maxlego08.essentials.api.dto.StepDTO;
import fr.maxlego08.essentials.api.dto.UserDTO;
import fr.maxlego08.essentials.api.dto.UserEconomyDTO;
import fr.maxlego08.essentials.api.dto.UserEconomyRankingDTO;
import fr.maxlego08.essentials.api.dto.UserVoteDTO;
import fr.maxlego08.essentials.api.dto.VaultDTO;
import fr.maxlego08.essentials.api.dto.VaultItemDTO;
import fr.maxlego08.essentials.api.economy.Economy;
import fr.maxlego08.essentials.api.home.Home;
import fr.maxlego08.essentials.api.mailbox.MailBoxItem;
import fr.maxlego08.essentials.api.sanction.Sanction;
import fr.maxlego08.essentials.api.steps.Step;
import fr.maxlego08.essentials.api.user.Option;
import fr.maxlego08.essentials.api.user.User;
import fr.maxlego08.essentials.api.user.UserRecord;
import fr.maxlego08.essentials.api.vault.Vault;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import org.bukkit.Material;

public interface IStorage {
    public void onEnable();

    public void onDisable();

    public User createOrLoad(UUID var1, String var2);

    public void onPlayerQuit(UUID var1);

    public User getUser(UUID var1);

    public void updateOption(UUID var1, Option var2, boolean var3);

    public void updateCooldown(UUID var1, String var2, long var3);

    public void updateEconomy(UUID var1, Economy var2, BigDecimal var3);

    public void deleteCooldown(UUID var1, String var2);

    public User updateUserMoney(UUID var1);

    public void getUserEconomy(String var1, Consumer<List<EconomyDTO>> var2);

    public void fetchUniqueId(String var1, Consumer<UUID> var2);

    public void storeTransactions(UUID var1, UUID var2, Economy var3, BigDecimal var4, BigDecimal var5, String var6);

    public List<EconomyTransactionDTO> getTransactions(UUID var1, Economy var2);

    public long totalUsers();

    public void upsertUser(User var1);

    public void upsertStorage(String var1, Object var2);

    public void upsertHome(UUID var1, Home var2);

    public void deleteHome(UUID var1, String var2);

    public void getHome(UUID var1, String var2, Consumer<Optional<Home>> var3);

    public void getHomes(UUID var1, Consumer<List<Home>> var2);

    public void insertSanction(Sanction var1, Consumer<Integer> var2);

    public void updateUserBan(UUID var1, Integer var2);

    public void updateUserMute(UUID var1, Integer var2);

    public boolean isBan(UUID var1);

    public Sanction getBan(UUID var1);

    public boolean isMute(UUID var1);

    public Sanction getMute(UUID var1);

    public List<SanctionDTO> getSanctions(UUID var1);

    public void insertChatMessage(UUID var1, String var2);

    public void insertPrivateMessage(UUID var1, UUID var2, String var3);

    public List<ChatMessageDTO> getMessages(UUID var1);

    public Map<Option, Boolean> getOptions(UUID var1);

    public void getOption(UUID var1, Option var2, Consumer<Boolean> var3);

    public void insertCommand(UUID var1, String var2);

    public void insertPlayTime(UUID var1, long var2, long var4, String var6);

    public UserRecord fetchUserRecord(UUID var1);

    public List<UserDTO> getUsers(String var1);

    public List<CooldownDTO> getCooldowns(UUID var1);

    public void setPowerTools(UUID var1, Material var2, String var3);

    public void deletePowerTools(UUID var1, Material var2);

    public void addMailBoxItem(MailBoxItem var1);

    public void clearMailBox(UUID var1);

    public void removeMailBoxItem(int var1);

    public List<UserEconomyRankingDTO> getEconomyRanking(Economy var1);

    public List<MailBoxDTO> getMailBox(UUID var1);

    public void fetchOfflinePlayerEconomies(Consumer<List<UserEconomyDTO>> var1);

    public void setVote(UUID var1, long var2, long var4);

    public UserVoteDTO getVote(UUID var1);

    public void updateServerStorage(String var1, Object var2);

    public void setLastVote(UUID var1, String var2);

    public void resetVotes();

    public void updateVaultQuantity(UUID var1, int var2, int var3, long var4);

    public void removeVaultItem(UUID var1, int var2, int var3);

    public void createVaultItem(UUID var1, int var2, int var3, long var4, String var6);

    public void setVaultSlot(UUID var1, int var2);

    public List<VaultDTO> getVaults();

    public List<VaultItemDTO> getVaultItems();

    public List<PlayerSlotDTO> getPlayerVaultSlots();

    public void updateVault(UUID var1, Vault var2);

    public void updateUserFrozen(UUID var1, boolean var2);

    public void upsertFlySeconds(UUID var1, long var2);

    public long getFlySeconds(UUID var1);

    public void deleteWorldData(String var1);

    public void linkDiscordAccount(UUID var1, String var2, String var3, long var4);

    public Optional<DiscordAccountDTO> selectDiscordAccount(UUID var1);

    public Optional<DiscordCodeDTO> selectCode(String var1);

    public void clearCode(DiscordCodeDTO var1);

    public void insertDiscordLog(DiscordAction var1, UUID var2, String var3, String var4, long var5, String var7);

    public void unlinkDiscordAccount(UUID var1);

    public StepDTO selectStep(UUID var1, Step var2);

    public void createStep(UUID var1, Step var2, long var3);

    public void finishStep(UUID var1, Step var2, String var3, long var4, long var6);

    public List<String> getPlayerNames();
}

