/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.api.utils;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public class DynamicCooldown {
    private long[] samples = new long[50];
    private final Map<UUID, Integer> latestSamplePos = new HashMap<UUID, Integer>();

    public void setSamples(int maxSamples) {
        this.samples = new long[maxSamples];
    }

    public void add(@NotNull UUID uniqueId) {
        int latestSamplePos = (this.latestSamplePos.getOrDefault(uniqueId, 0) + 1) % this.samples.length;
        this.samples[latestSamplePos] = System.currentTimeMillis();
        this.latestSamplePos.put(uniqueId, latestSamplePos);
    }

    public long limited(@NotNull UUID uniqueId, long ... limits) {
        Preconditions.checkArgument((limits.length > 0 ? 1 : 0) != 0, (Object)"Limits array cannot be empty.");
        Preconditions.checkArgument((limits.length % 2 == 0 ? 1 : 0) != 0, (Object)"Limits array must contain pairs of values.");
        long currentTime = System.currentTimeMillis();
        long maxNextInterval = 0L;
        for (int i = 0; i < limits.length; i += 2) {
            int pos;
            long diff;
            long interval = limits[i];
            long limit = limits[i + 1];
            for (int j = 0; (long)j < limit && j < this.samples.length && (diff = currentTime - this.samples[pos = (this.latestSamplePos.getOrDefault(uniqueId, 0) - j + this.samples.length) % this.samples.length]) < interval; ++j) {
                long nextInterval;
                if ((long)(j + 1) != limit || (nextInterval = interval - diff) <= maxNextInterval) continue;
                maxNextInterval = nextInterval;
            }
        }
        return maxNextInterval;
    }
}

