/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.api.utils;

import org.bukkit.Bukkit;
import org.bukkit.Location;

public class SafeLocation {
    private final String world;
    private double x;
    private double y;
    private double z;
    private float yaw;
    private float pitch;
    private transient Location location;

    public SafeLocation(String world, double x, double y, double z, float yaw, float pitch) {
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
        this.yaw = yaw;
        this.pitch = pitch;
    }

    public SafeLocation(Location location) {
        this(location.getWorld().getName(), location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
        this.location = location;
    }

    public String getWorld() {
        return this.world;
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
        this.location = null;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
        this.location = null;
    }

    public double getZ() {
        return this.z;
    }

    public void setZ(double z) {
        this.z = z;
        this.location = null;
    }

    public float getYaw() {
        return this.yaw;
    }

    public void setYaw(float yaw) {
        this.yaw = yaw;
        this.location = null;
    }

    public float getPitch() {
        return this.pitch;
    }

    public void setPitch(float pitch) {
        this.pitch = pitch;
        this.location = null;
    }

    public Location getLocation() {
        if (this.location == null) {
            this.location = new Location(Bukkit.getWorld((String)this.world), this.x, this.y, this.z, this.yaw, this.pitch);
        }
        return this.location;
    }

    public boolean isValid() {
        return this.world != null && Bukkit.getWorld((String)this.world) != null;
    }

    public String toString() {
        return "SafeLocation{world='" + this.world + "', x=" + this.x + ", y=" + this.y + ", z=" + this.z + ", yaw=" + this.yaw + ", pitch=" + this.pitch + ", location=" + String.valueOf(this.location) + "}";
    }

    public int getBlockX() {
        return (int)this.x;
    }

    public int getBlockY() {
        return (int)this.y;
    }

    public int getBlockZ() {
        return (int)this.z;
    }

    public void set(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.location = null;
    }
}

