/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.buttons;

import fr.maxlego08.essentials.api.EssentialsPlugin;
import fr.maxlego08.essentials.api.user.Option;
import fr.maxlego08.essentials.api.user.User;
import fr.maxlego08.menu.api.MenuItemStack;
import fr.maxlego08.menu.api.button.Button;
import fr.maxlego08.menu.api.engine.InventoryEngine;
import fr.maxlego08.menu.api.utils.Placeholders;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;

public class ButtonOption
extends Button {
    private final EssentialsPlugin plugin;
    private final Option option;
    private final List<Integer> offsetSlots;
    private final MenuItemStack enableItemStack;
    private final MenuItemStack disableItemStack;
    private final MenuItemStack offsetEnableItemStack;
    private final MenuItemStack offsetDisableItemStack;

    public ButtonOption(EssentialsPlugin plugin, Option option, List<Integer> offsetSlots, MenuItemStack enableItemStack, MenuItemStack disableItemStack, MenuItemStack offsetEnableItemStack, MenuItemStack offsetDisableItemStack) {
        this.plugin = plugin;
        this.option = option;
        this.offsetSlots = offsetSlots;
        this.enableItemStack = enableItemStack;
        this.disableItemStack = disableItemStack;
        this.offsetEnableItemStack = offsetEnableItemStack;
        this.offsetDisableItemStack = offsetDisableItemStack;
    }

    public boolean hasSpecialRender() {
        return true;
    }

    public void onRender(Player player, InventoryEngine inventory) {
        User user = this.plugin.getUser(player.getUniqueId());
        boolean isActive = user.getOption(this.option);
        MenuItemStack itemStack = isActive ? this.enableItemStack : this.disableItemStack;
        for (Integer slot : this.getSlots()) {
            inventory.addItem(slot.intValue(), itemStack.build(player, false)).setClick(event -> this.toggleOption(player, inventory, slot, (InventoryClickEvent)event, user, isActive));
            for (Integer offsetSlot : this.offsetSlots) {
                MenuItemStack offsetItemStack = isActive ? this.offsetEnableItemStack : this.offsetDisableItemStack;
                inventory.addItem(slot + offsetSlot, offsetItemStack.build(player, false)).setClick(event -> this.toggleOption(player, inventory, slot, (InventoryClickEvent)event, user, isActive));
            }
        }
    }

    private void toggleOption(Player player, InventoryEngine inventory, Integer slot, InventoryClickEvent event, User user, boolean isActive) {
        super.onClick(player, event, inventory, slot.intValue(), new Placeholders());
        if (this.option == Option.DISABLE_SCOREBOARD) {
            this.plugin.getScoreboardManager().toggleScoreboard(player, true);
        } else {
            user.setOption(this.option, !isActive);
        }
        this.onRender(player, inventory);
    }
}

