/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.buttons.sanction;

import fr.maxlego08.essentials.api.EssentialsPlugin;
import fr.maxlego08.essentials.api.sanction.SanctionType;
import fr.maxlego08.essentials.api.user.User;
import fr.maxlego08.essentials.module.modules.SanctionModule;
import fr.maxlego08.menu.api.button.Button;
import fr.maxlego08.menu.api.engine.InventoryEngine;
import fr.maxlego08.menu.api.utils.Placeholders;
import java.time.Duration;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;

public class ButtonSanction
extends Button {
    private final EssentialsPlugin plugin;
    private final Duration duration;
    private final SanctionType type;
    private final String reason;

    public ButtonSanction(EssentialsPlugin plugin, Duration duration, SanctionType type, String reason) {
        this.plugin = plugin;
        this.duration = duration;
        this.type = type;
        this.reason = reason;
    }

    public void onClick(Player player, InventoryClickEvent event, InventoryEngine inventory, int slot, Placeholders placeholders) {
        super.onClick(player, event, inventory, slot, placeholders);
        User user = this.plugin.getUser(player.getUniqueId());
        if (user == null) {
            return;
        }
        User targetuser = user.getTargetUser();
        if (targetuser == null) {
            return;
        }
        SanctionModule sanctionModule = this.plugin.getModuleManager().getModule(SanctionModule.class);
        player.closeInventory();
        switch (this.type) {
            case KICK: {
                sanctionModule.kick((CommandSender)player, targetuser.getUniqueId(), targetuser.getName(), this.reason);
                break;
            }
            case MUTE: {
                sanctionModule.mute((CommandSender)player, targetuser.getUniqueId(), targetuser.getName(), this.duration, this.reason);
                break;
            }
            case BAN: {
                sanctionModule.ban((CommandSender)player, targetuser.getUniqueId(), targetuser.getName(), this.duration, this.reason);
                break;
            }
            case UNBAN: {
                sanctionModule.unban((CommandSender)player, targetuser.getUniqueId(), targetuser.getName(), this.reason);
                break;
            }
            case UNMUTE: {
                sanctionModule.unmute((CommandSender)player, targetuser.getUniqueId(), targetuser.getName(), this.reason);
                break;
            }
            case WARN: {
                player.sendMessage("\u00a7cTODO");
                break;
            }
            case FREEZE: {
                sanctionModule.freeze((CommandSender)player, targetuser.getUniqueId(), targetuser.getName());
            }
        }
    }
}

