/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.buttons.vault;

import fr.maxlego08.essentials.api.EssentialsPlugin;
import fr.maxlego08.essentials.api.commands.Permission;
import fr.maxlego08.essentials.api.vault.PlayerVaults;
import fr.maxlego08.essentials.api.vault.Vault;
import fr.maxlego08.essentials.api.vault.VaultItem;
import fr.maxlego08.essentials.api.vault.VaultManager;
import fr.maxlego08.essentials.api.vault.VaultResult;
import fr.maxlego08.menu.api.button.Button;
import fr.maxlego08.menu.api.engine.InventoryEngine;
import fr.maxlego08.menu.api.utils.Placeholders;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class ButtonVaultSlotItems
extends Button {
    private final EssentialsPlugin plugin;

    public ButtonVaultSlotItems(Plugin plugin) {
        this.plugin = (EssentialsPlugin)plugin;
    }

    public boolean hasSpecialRender() {
        return true;
    }

    public void onInventoryOpen(Player player, InventoryEngine inventory, Placeholders placeholders) {
        PlayerVaults playerVaults = this.plugin.getVaultManager().getPlayerVaults((OfflinePlayer)player);
        Vault vault = playerVaults.getTargetVault();
        boolean editable = vault != null && (vault.getUniqueId().equals(player.getUniqueId()) || player.hasPermission(Permission.ESSENTIALS_VAULT_SHOW_EDIT.asPermission()));
        inventory.setDisablePlayerInventoryClick(!editable);
        if (vault == null) {
            return;
        }
        placeholders.register("vault-name", vault.getName());
        OfflinePlayer owner = Bukkit.getOfflinePlayer((UUID)vault.getUniqueId());
        placeholders.register("player", owner.getName());
    }

    public void onRender(Player player, InventoryEngine inventory) {
        VaultManager manager = this.plugin.getVaultManager();
        PlayerVaults playerVaults = manager.getPlayerVaults((OfflinePlayer)player);
        Vault vault = playerVaults.getTargetVault();
        if (vault == null) {
            return;
        }
        int startSlot = this.getStartSlot(player);
        if (startSlot > 0 && startSlot < this.slots.size()) {
            for (int index = 0; index < startSlot; ++index) {
                this.releaseSlot(inventory, index);
            }
        }
        vault.getVaultItems().forEach((slot, vaultItem) -> this.setVaultItem((Integer)slot, vault, (VaultItem)vaultItem, inventory, player));
    }

    private void setVaultItem(Integer slot, Vault vault, VaultItem vaultItem, InventoryEngine inventory, Player player) {
        ItemStack itemStack = vaultItem.getDisplayItemStack(player, this.plugin.getComponentMessage());
        inventory.addItem(slot.intValue(), itemStack).setClick(event -> {
            event.setCancelled(true);
            this.onBagClick(player, vault, vaultItem, event.getClick(), slot, inventory, (InventoryClickEvent)event);
        });
    }

    private void onBagClick(Player player, Vault vault, VaultItem vaultItem, ClickType clickType, int slot, InventoryEngine inventoryDefault, InventoryClickEvent event) {
        boolean isPickup;
        VaultManager manager = this.plugin.getVaultManager();
        InventoryAction action = event.getAction();
        boolean bl = isPickup = action == InventoryAction.PICKUP_ALL || action == InventoryAction.PICKUP_HALF || action == InventoryAction.PICKUP_ONE || action == InventoryAction.PICKUP_SOME;
        if (!vault.getUniqueId().equals(player.getUniqueId()) && !player.hasPermission(Permission.ESSENTIALS_VAULT_SHOW_EDIT.asPermission())) {
            return;
        }
        if (clickType == ClickType.RIGHT && isPickup) {
            manager.remove(vault, vaultItem, player, 64L, slot);
            this.updateInventoryBag(player, vaultItem, slot, inventoryDefault, vault);
        } else if (clickType == ClickType.LEFT && isPickup) {
            manager.remove(vault, vaultItem, player, 1L, slot);
            this.updateInventoryBag(player, vaultItem, slot, inventoryDefault, vault);
        } else if (clickType == ClickType.SHIFT_LEFT) {
            manager.remove(vault, vaultItem, player, -1L, slot);
            this.updateInventoryBag(player, vaultItem, slot, inventoryDefault, vault);
        }
    }

    private void updateInventoryBag(Player player, VaultItem bagItem, int slot, InventoryEngine inventoryDefault, Vault vault) {
        if (bagItem.getQuantity() <= 0L || !vault.contains(slot)) {
            this.releaseSlot(inventoryDefault, slot);
        } else {
            inventoryDefault.getSpigotInventory().setItem(slot, bagItem.getDisplayItemStack(player, this.plugin.getComponentMessage()));
        }
    }

    protected void releaseSlot(InventoryEngine inventory, int slot) {
        inventory.addItem(slot, new ItemStack(Material.AIR)).setClick(event -> event.setCancelled(true));
    }

    public void onInventoryClick(InventoryClickEvent event, Player player, InventoryEngine inventoryDefault) {
        boolean editable;
        ClickType clickType = event.getClick();
        ItemStack itemStack = event.getCurrentItem();
        ItemStack cursorItemStack = event.getCursor();
        int slot = event.getSlot();
        Inventory topInventory = player.getOpenInventory().getTopInventory();
        VaultManager manager = this.plugin.getVaultManager();
        PlayerVaults playerVaults = manager.getPlayerVaults((OfflinePlayer)player);
        Vault vault = playerVaults.getTargetVault();
        if (vault == null) {
            event.setCancelled(true);
            return;
        }
        boolean bl = editable = vault.getUniqueId().equals(player.getUniqueId()) || player.hasPermission(Permission.ESSENTIALS_VAULT_SHOW_EDIT.asPermission());
        if (!editable) {
            event.setCancelled(true);
            return;
        }
        if (event.getWhoClicked().getInventory().equals((Object)event.getClickedInventory()) && clickType.isShiftClick() && itemStack != null && itemStack.getType() != Material.AIR) {
            VaultResult vaultResult = manager.addVaultItem(vault, player.getUniqueId(), event.getCurrentItem(), -1, itemStack.getAmount(), this.slots.size());
            if (vaultResult == null) {
                event.setCancelled(true);
                return;
            }
            event.setCurrentItem(null);
            if (vaultResult.vault().getVaultId() == vault.getVaultId()) {
                this.setVaultItem(vaultResult.slot(), vault, vault.getVaultItems().get(vaultResult.slot()), inventoryDefault, player);
            } else {
                manager.openVault(player, vaultResult.vault().getVaultId());
            }
        } else if (topInventory.equals((Object)event.getClickedInventory()) && !cursorItemStack.getType().equals((Object)Material.AIR)) {
            if (!this.isValidSlot(slot, player)) {
                event.setCancelled(true);
                return;
            }
            VaultItem vaultItem = vault.getVaultItems().get(slot);
            if (vaultItem != null && !vaultItem.getItemStack().isSimilar(cursorItemStack)) {
                return;
            }
            if (event.getClick().equals((Object)ClickType.RIGHT)) {
                VaultResult vaultResult = manager.addVaultItem(vault, player.getUniqueId(), cursorItemStack, slot, 1, this.slots.size());
                if (vaultResult == null) {
                    event.setCancelled(true);
                    return;
                }
                event.setCursor(cursorItemStack.subtract());
                if (vaultResult.vault().getVaultId() == vault.getVaultId()) {
                    this.setVaultItem(vaultResult.slot(), vault, vault.getVaultItems().get(vaultResult.slot()), inventoryDefault, player);
                } else {
                    manager.openVault(player, vaultResult.vault().getVaultId());
                }
            } else if (event.getClick().equals((Object)ClickType.LEFT)) {
                VaultResult vaultResult = manager.addVaultItem(vault, player.getUniqueId(), cursorItemStack, slot, cursorItemStack.getAmount(), this.slots.size());
                if (vaultResult == null) {
                    event.setCancelled(true);
                    return;
                }
                event.setCursor(null);
                if (vaultResult.vault().getVaultId() == vault.getVaultId()) {
                    this.setVaultItem(vaultResult.slot(), vault, vault.getVaultItems().get(vaultResult.slot()), inventoryDefault, player);
                } else {
                    manager.openVault(player, vaultResult.vault().getVaultId());
                }
            }
        }
    }

    public void onDrag(InventoryDragEvent event, Player player, InventoryEngine inventoryDefault) {
        event.setCancelled(true);
    }

    private boolean isValidSlot(int slot, Player player) {
        int startSlot = this.getStartSlot(player);
        if (startSlot > 0 && startSlot < this.slots.size()) {
            return slot < startSlot;
        }
        return true;
    }

    private int getStartSlot(Player player) {
        VaultManager manager = this.plugin.getVaultManager();
        PlayerVaults playerVaults = manager.getPlayerVaults((OfflinePlayer)player);
        Vault vault = playerVaults.getTargetVault();
        if (vault == null) {
            return 0;
        }
        int size = this.slots.size();
        return manager.getMaxSlotsPlayer(player) - size * (vault.getVaultId() - 1);
    }
}

