/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.essentials.commands;

import fr.maxlego08.essentials.ZEssentialsPlugin;
import fr.maxlego08.essentials.api.Configuration;
import fr.maxlego08.essentials.api.commands.CommandManager;
import fr.maxlego08.essentials.api.commands.CommandResultType;
import fr.maxlego08.essentials.api.commands.EssentialsCommand;
import fr.maxlego08.essentials.api.commands.Permission;
import fr.maxlego08.essentials.api.messages.Message;
import fr.maxlego08.essentials.api.user.User;
import fr.maxlego08.essentials.zutils.utils.TimerBuilder;
import fr.maxlego08.essentials.zutils.utils.ZUtils;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class ZCommandManager
extends ZUtils
implements CommandManager {
    private static CommandMap commandMap;
    private static Constructor<? extends PluginCommand> constructor;
    protected final List<EssentialsCommand> commands = new ArrayList<EssentialsCommand>();
    private final ZEssentialsPlugin plugin;

    public ZCommandManager(ZEssentialsPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void registerCommand(EssentialsCommand command) {
        this.commands.add(command);
    }

    @Override
    public void registerCommand(String string, EssentialsCommand command) {
        command.addSubCommand(string);
        this.commands.add(command);
        this.plugin.getCommand(string).setExecutor((CommandExecutor)this);
        this.plugin.getCommand(string).setTabCompleter((TabCompleter)this);
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command cmd, @NotNull String label, String[] args) {
        for (EssentialsCommand command : this.commands) {
            CommandResultType type;
            if (!(command.getSubCommands().contains(cmd.getName().toLowerCase()) ? (args.length == 0 || command.isIgnoreParent()) && command.getParent() == null && !(type = this.processRequirements(command, sender, args)).equals((Object)CommandResultType.CONTINUE) : args.length >= 1 && command.getParent() != null && this.canExecute(args, cmd.getName().toLowerCase(), command) && !(type = this.processRequirements(command, sender, args)).equals((Object)CommandResultType.CONTINUE))) continue;
            return true;
        }
        this.message(sender, Message.COMMAND_NO_ARG, new Object[0]);
        return true;
    }

    private boolean canExecute(String[] args, String cmd, EssentialsCommand command) {
        for (int index = args.length - 1; index > -1; --index) {
            if (!command.getSubCommands().contains(args[index].toLowerCase())) continue;
            if (command.isIgnoreArgs() && (command.getParent() == null || this.canExecute(args, cmd, command.getParent(), index - 1))) {
                return true;
            }
            if (index < args.length - 1) {
                return false;
            }
            return this.canExecute(args, cmd, command.getParent(), index - 1);
        }
        return false;
    }

    private boolean canExecute(String[] args, String cmd, EssentialsCommand command, int index) {
        if (index < 0 && command.getSubCommands().contains(cmd.toLowerCase())) {
            return true;
        }
        if (index < 0) {
            return false;
        }
        if (command.getSubCommands().contains(args[index].toLowerCase())) {
            return this.canExecute(args, cmd, command.getParent(), index - 1);
        }
        return false;
    }

    private CommandResultType processRequirements(EssentialsCommand command, CommandSender sender, String[] strings) {
        if (!(sender instanceof Player) && !command.isConsoleCanUse()) {
            this.message(sender, Message.COMMAND_NO_CONSOLE, new Object[0]);
            return CommandResultType.DEFAULT;
        }
        if (command.getPermission() == null || sender.hasPermission(command.getPermission())) {
            CommandResultType returnType = command.prePerform(this.plugin, sender, strings);
            if (returnType == CommandResultType.SYNTAX_ERROR) {
                this.message(sender, Message.COMMAND_SYNTAX_ERROR, "%syntax%", command.getSyntax());
            } else if (returnType == CommandResultType.NO_PERMISSION) {
                this.message(sender, Message.COMMAND_NO_PERMISSION, new Object[0]);
            }
            return returnType;
        }
        this.message(sender, Message.COMMAND_NO_PERMISSION, new Object[0]);
        return CommandResultType.DEFAULT;
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String str, String[] args) {
        for (EssentialsCommand command : this.commands) {
            if (command.getSubCommands().contains(cmd.getName().toLowerCase()) && command.getParent() == null) {
                return this.processTab(sender, command, args);
            }
            String[] newArgs = Arrays.copyOf(args, args.length - 1);
            if (newArgs.length < 1 || command.getParent() == null || !this.canExecute(newArgs, cmd.getName().toLowerCase(), command)) continue;
            return this.processTab(sender, command, args);
        }
        return List.of();
    }

    public List<String> processTab(CommandSender sender, EssentialsCommand command, String[] args) {
        CommandResultType type = command.getTabCompleter();
        if (type.equals((Object)CommandResultType.DEFAULT)) {
            String startWith = args[args.length - 1];
            ArrayList<String> tabCompleter = new ArrayList<String>();
            for (EssentialsCommand vCommand : this.commands) {
                if (vCommand.getParent() == null || vCommand.getParent() != command) continue;
                String cmd = vCommand.getSubCommands().getFirst();
                if (vCommand.getPermission() != null && !sender.hasPermission(vCommand.getPermission()) || !startWith.isEmpty() && !cmd.startsWith(startWith)) continue;
                tabCompleter.add(cmd);
            }
            return tabCompleter.isEmpty() ? List.of() : tabCompleter;
        }
        if (type.equals((Object)CommandResultType.SUCCESS)) {
            List<String> list = command.toTab(this.plugin, sender, args);
            return list == null ? List.of() : list.stream().limit(100L).toList();
        }
        return List.of();
    }

    private YamlConfiguration getCommandConfiguration() {
        File file = new File(this.plugin.getDataFolder(), "commands.yml");
        if (!file.exists()) {
            try {
                if (!file.createNewFile()) {
                    this.plugin.getLogger().severe("The commands.yml file cannot be created.");
                    return null;
                }
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
        }
        return YamlConfiguration.loadConfiguration((File)file);
    }

    public void saveCommandConfiguration(YamlConfiguration configuration) {
        File file = new File(this.plugin.getDataFolder(), "commands.yml");
        try {
            configuration.save(file);
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void saveCommands() {
        YamlConfiguration configuration = this.getCommandConfiguration();
        if (configuration == null) {
            return;
        }
        List<EssentialsCommand> essentialsCommands = this.getSortCommands();
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        essentialsCommands.forEach(essentialsCommand -> {
            String commandName = this.getCommandName((EssentialsCommand)essentialsCommand);
            ConfigurationSection configurationSection = configuration.getConfigurationSection(commandName);
            if (configurationSection != null) {
                return;
            }
            configuration.set(commandName + ".enable", (Object)true);
            configuration.set(commandName + ".commands", essentialsCommand.getSubCommands());
            configuration.set(commandName + ".permission", (Object)essentialsCommand.getPermission());
            atomicBoolean.set(true);
        });
        if (atomicBoolean.get()) {
            this.saveCommandConfiguration(configuration);
        }
    }

    private String getCommandName(EssentialsCommand command) {
        String className = command.getClass().getSimpleName();
        StringBuilder transformedName = new StringBuilder();
        for (int i = 0; i < className.length(); ++i) {
            char currentChar = className.charAt(i);
            if (Character.isUpperCase(currentChar)) {
                if (i != 0) {
                    transformedName.append('-');
                }
                transformedName.append(Character.toLowerCase(currentChar));
                continue;
            }
            transformedName.append(currentChar);
        }
        return transformedName.toString();
    }

    @Override
    public void registerCommand(Plugin plugin, String mainCommand, EssentialsCommand essentialsCommand, List<String> aliases) {
        String commandName;
        ConfigurationSection configurationSection;
        YamlConfiguration configuration = this.getCommandConfiguration();
        if (configuration != null && (configurationSection = configuration.getConfigurationSection(commandName = this.getCommandName(essentialsCommand))) != null) {
            if (!configurationSection.getBoolean("enable", true)) {
                return;
            }
            List commands = configurationSection.getStringList("commands");
            if (commands.isEmpty()) {
                this.plugin.getLogger().severe("Command " + commandName + " doesnt have commands !");
            } else {
                mainCommand = (String)commands.remove(0);
                aliases = commands;
            }
            essentialsCommand.setPermission(configurationSection.getString("permission"));
        }
        try {
            PluginCommand command = constructor.newInstance(mainCommand, plugin);
            command.setExecutor((CommandExecutor)this);
            command.setTabCompleter((TabCompleter)this);
            command.setAliases(aliases);
            if (essentialsCommand.getPermission() != null) {
                command.setPermission(essentialsCommand.getPermission());
            }
            essentialsCommand.addSubCommand(mainCommand);
            essentialsCommand.addSubCommand(aliases);
            this.commands.add(essentialsCommand);
            if (!commandMap.register(command.getName(), plugin.getDescription().getName(), (Command)command)) {
                plugin.getLogger().info("Unable to add the command " + essentialsCommand.getSyntax());
            }
            if (essentialsCommand.getPermission() != null) {
                Bukkit.getPluginManager().addPermission(new org.bukkit.permissions.Permission(essentialsCommand.getPermission(), essentialsCommand.getDescription() == null ? "No description" : essentialsCommand.getDescription()));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public int countCommands() {
        return this.commands.size();
    }

    @Override
    public List<EssentialsCommand> getCommands() {
        return this.commands;
    }

    @Override
    public List<EssentialsCommand> getSortCommands() {
        ArrayList<EssentialsCommand> essentialsCommands = new ArrayList<EssentialsCommand>();
        this.commands.stream().filter(e -> e.getParent() == null).sorted(Comparator.comparing(EssentialsCommand::getMainCommand)).forEach(command -> {
            essentialsCommands.add((EssentialsCommand)command);
            essentialsCommands.addAll(this.commands.stream().filter(e -> e.getMainParent() == command).sorted(Comparator.comparing(EssentialsCommand::getMainCommand)).toList());
        });
        return essentialsCommands;
    }

    private boolean isEssentialsCommand(String command) {
        return this.commands.stream().anyMatch(e -> e.getParent() == null && e.getSubCommands().contains(command));
    }

    @EventHandler
    public void onCommand(PlayerCommandPreprocessEvent event) {
        Optional<Integer> optional;
        String key;
        Player player = event.getPlayer();
        String[] split = event.getMessage().substring(1).split(" ");
        String string = key = split.length > 0 ? split[0].toLowerCase() : "";
        if (this.isEssentialsCommand(key)) {
            return;
        }
        User user = this.plugin.getUser(player.getUniqueId());
        int cooldownSeconds = 0;
        Configuration configuration = this.plugin.getConfiguration();
        if (!(user == null || user.hasPermission(Permission.ESSENTIALS_BYPASS_COOLDOWN) && configuration.isEnableCooldownBypass() || !(optional = configuration.getCooldown((Permissible)player, key)).isPresent())) {
            cooldownSeconds = optional.get();
            if (user.isCooldown(key)) {
                event.setCancelled(true);
                long milliSeconds = user.getCooldown(key) - System.currentTimeMillis();
                this.message((CommandSender)player, Message.COOLDOWN, "%cooldown%", TimerBuilder.getStringTime(milliSeconds));
            } else {
                user.addCooldown(key, cooldownSeconds);
            }
        }
    }

    static {
        try {
            Field bukkitCommandMap = Bukkit.getServer().getClass().getDeclaredField("commandMap");
            bukkitCommandMap.setAccessible(true);
            commandMap = (CommandMap)bukkitCommandMap.get(Bukkit.getServer());
            constructor = PluginCommand.class.getDeclaredConstructor(String.class, Plugin.class);
            constructor.setAccessible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

